/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.config;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.config.ConfigItem;
import io.confluent.ksql.config.ConfigResolver;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlRequestConfig;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.streams.StreamsConfig;

public class KsqlConfigResolver
implements ConfigResolver {
    private static final ConfigDef STREAMS_CONFIG_DEF = StreamsConfig.configDef();
    private static final ConfigDef CONSUMER_CONFIG_DEF = KsqlConfigResolver.getConfigDef(ConsumerConfig.class);
    private static final ConfigDef PRODUCER_CONFIG_DEF = KsqlConfigResolver.getConfigDef(ProducerConfig.class);
    private static final ConfigDef KSQL_CONFIG_DEF = KsqlConfig.CURRENT_DEF;
    private static final ConfigDef REQUEST_CONFIG_DEF = KsqlRequestConfig.CURRENT_DEF;
    private static final List<PrefixedConfig> STREAM_CONFIG_DEFS = ImmutableList.of((Object)new PrefixedConfig("consumer.", CONSUMER_CONFIG_DEF), (Object)new PrefixedConfig("producer.", PRODUCER_CONFIG_DEF), (Object)new PrefixedConfig("", CONSUMER_CONFIG_DEF), (Object)new PrefixedConfig("", PRODUCER_CONFIG_DEF), (Object)new PrefixedConfig("", STREAMS_CONFIG_DEF));

    @Override
    public Optional<ConfigItem> resolve(String propertyName, boolean strict) {
        if (propertyName.startsWith("request.ksql.")) {
            return KsqlConfigResolver.resolveRequestConfig(propertyName);
        }
        if (propertyName.startsWith("ksql.") && !propertyName.startsWith("ksql.streams.")) {
            return KsqlConfigResolver.resolveKsqlConfig(propertyName);
        }
        return KsqlConfigResolver.resolveStreamsConfig(propertyName, strict);
    }

    private static Optional<ConfigItem> resolveStreamsConfig(String propertyName, boolean strict) {
        String topicKey;
        String key = KsqlConfigResolver.stripPrefix(propertyName, "ksql.streams.");
        Optional<ConfigItem> resolved = STREAM_CONFIG_DEFS.stream().map(def -> KsqlConfigResolver.resolveConfig(def.prefix, def.def, key)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (resolved.isPresent()) {
            return resolved;
        }
        if (propertyName.startsWith("ksql.streams.") && !propertyName.startsWith("ksql.streams.producer.") && !propertyName.startsWith("ksql.streams.consumer.") && !propertyName.startsWith("ksql.streams.topic.")) {
            return Optional.empty();
        }
        if (key.startsWith("topic.") && KsqlConfig.STREAM_TOPIC_CONFIG_NAMES.contains(topicKey = KsqlConfigResolver.stripPrefix(key, "topic."))) {
            return Optional.of(ConfigItem.unresolved(key));
        }
        return strict ? Optional.empty() : Optional.of(ConfigItem.unresolved(key));
    }

    private static Optional<ConfigItem> resolveKsqlConfig(String propertyName) {
        Optional<ConfigItem> possibleItem = KsqlConfigResolver.resolveConfig("", KSQL_CONFIG_DEF, propertyName);
        if (possibleItem.isPresent()) {
            return possibleItem;
        }
        if (propertyName.startsWith("ksql.functions.")) {
            return Optional.of(ConfigItem.unresolved(propertyName));
        }
        return Optional.empty();
    }

    private static Optional<ConfigItem> resolveRequestConfig(String propertyName) {
        Optional<ConfigItem> possibleItem = KsqlConfigResolver.resolveConfig("", REQUEST_CONFIG_DEF, propertyName);
        if (possibleItem.isPresent()) {
            return possibleItem;
        }
        return Optional.empty();
    }

    private static Optional<ConfigItem> resolveConfig(String prefix, ConfigDef def, String propertyName) {
        if (!propertyName.startsWith(prefix)) {
            return Optional.empty();
        }
        String keyNoPrefix = KsqlConfigResolver.stripPrefix(propertyName, prefix);
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)def.configKeys().get(keyNoPrefix);
        if (configKey != null) {
            return Optional.of(ConfigItem.resolved(configKey));
        }
        if (KsqlConfigResolver.isInternalStreamsConfig(keyNoPrefix)) {
            return Optional.of(ConfigItem.unresolved(keyNoPrefix));
        }
        return Optional.empty();
    }

    private static boolean isInternalStreamsConfig(String key) {
        return key.equals("__emit.interval.ms.kstreams.outer.join.spurious.results.fix__") || key.equals("__emit.interval.ms.kstreams.windowed.aggregation__");
    }

    private static String stripPrefix(String maybePrefixedKey, String prefix) {
        return maybePrefixedKey.startsWith(prefix) ? maybePrefixedKey.substring(prefix.length()) : maybePrefixedKey;
    }

    static ConfigDef getConfigDef(Class<? extends AbstractConfig> defClass) {
        try {
            Field field = defClass.getDeclaredField("CONFIG");
            field.setAccessible(true);
            return (ConfigDef)field.get(null);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to initialize config def for " + defClass);
        }
    }

    private static final class PrefixedConfig {
        final String prefix;
        final ConfigDef def;

        private PrefixedConfig(String prefix, ConfigDef configDef) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            this.def = Objects.requireNonNull(configDef, "configDef");
        }
    }
}

