/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util.timestamp;

import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.ColumnRef;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SqlBaseType;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.timestamp.LongColumnTimestampExtractionPolicy;
import io.confluent.ksql.util.timestamp.MetadataTimestampExtractionPolicy;
import io.confluent.ksql.util.timestamp.StringTimestampExtractionPolicy;
import io.confluent.ksql.util.timestamp.TimestampExtractionPolicy;
import java.util.Optional;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TimestampExtractor;

public final class TimestampExtractionPolicyFactory {
    private TimestampExtractionPolicyFactory() {
    }

    public static TimestampExtractionPolicy create(KsqlConfig ksqlConfig, LogicalSchema schema, Optional<ColumnRef> timestampColumnName, Optional<String> timestampFormat) {
        if (!timestampColumnName.isPresent()) {
            return new MetadataTimestampExtractionPolicy(TimestampExtractionPolicyFactory.getDefaultTimestampExtractor(ksqlConfig));
        }
        ColumnRef col = timestampColumnName.get();
        Column timestampColumn = schema.findValueColumn(col).orElseThrow(() -> new KsqlException("The TIMESTAMP column set in the WITH clause does not exist in the schema: '" + col.toString(FormatOptions.noEscape()) + "'"));
        SqlBaseType tsColumnType = timestampColumn.type().baseType();
        if (tsColumnType == SqlBaseType.STRING) {
            String format = timestampFormat.orElseThrow(() -> new KsqlException("A String timestamp field has been specified without also specifying the " + "TIMESTAMP_FORMAT".toLowerCase()));
            return new StringTimestampExtractionPolicy(col, format);
        }
        if (timestampFormat.isPresent()) {
            throw new KsqlException("'TIMESTAMP_FORMAT' set in the WITH clause can only be used when the timestamp column in of type STRING.");
        }
        if (tsColumnType == SqlBaseType.BIGINT) {
            return new LongColumnTimestampExtractionPolicy(col);
        }
        throw new KsqlException("Timestamp column, " + timestampColumnName + ", should be LONG(INT64) or a String with a " + "TIMESTAMP_FORMAT".toLowerCase() + " specified");
    }

    private static TimestampExtractor getDefaultTimestampExtractor(KsqlConfig ksqlConfig) {
        try {
            Class<FailOnInvalidTimestamp> timestampExtractorClass = ksqlConfig.getKsqlStreamConfigProps().getOrDefault("default.timestamp.extractor", FailOnInvalidTimestamp.class);
            return (TimestampExtractor)timestampExtractorClass.newInstance();
        }
        catch (Exception e) {
            throw new KsqlException("Cannot override default timestamp extractor: " + e.getMessage(), e);
        }
    }
}

