/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util.timestamp;

import com.google.common.base.Preconditions;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.timestamp.StringToTimestampParser;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.processor.TimestampExtractor;

public class StringTimestampExtractor
implements TimestampExtractor {
    private final StringToTimestampParser timestampParser;
    private final int timestampColumn;
    private final String format;

    StringTimestampExtractor(String format, int timestampColumn) {
        this.format = Objects.requireNonNull(format, "format can't be null");
        Preconditions.checkArgument((timestampColumn >= 0 ? 1 : 0) != 0, (Object)"timestampColumn must be >= 0");
        this.timestampColumn = timestampColumn;
        this.timestampParser = new StringToTimestampParser(format);
    }

    public long extract(ConsumerRecord<Object, Object> consumerRecord, long previousTimestamp) {
        GenericRow row = (GenericRow)consumerRecord.value();
        String value = (String)row.getColumnValue(this.timestampColumn);
        try {
            return this.timestampParser.parse(value);
        }
        catch (KsqlException e) {
            throw new KsqlException("Unable to parse string timestamp from record. record=" + consumerRecord + " timestamp=" + value + " timestamp_format=" + this.format, (Throwable)((Object)e));
        }
    }
}

