/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util.timestamp;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.ColumnRef;
import io.confluent.ksql.util.timestamp.StringTimestampExtractor;
import io.confluent.ksql.util.timestamp.TimestampExtractionPolicy;
import java.util.Objects;
import org.apache.kafka.streams.processor.TimestampExtractor;

@Immutable
public class StringTimestampExtractionPolicy
implements TimestampExtractionPolicy {
    private final ColumnRef timestampField;
    private final String format;

    public StringTimestampExtractionPolicy(ColumnRef timestampField, String format) {
        Objects.requireNonNull(timestampField, "timestampField can't be null");
        Objects.requireNonNull(format, "format can't be null");
        this.timestampField = timestampField;
        this.format = format;
    }

    @Override
    public TimestampExtractor create(int timestampColumnIndex) {
        return new StringTimestampExtractor(this.format, timestampColumnIndex);
    }

    @Override
    public ColumnRef timestampField() {
        return this.timestampField;
    }

    public int hashCode() {
        return Objects.hash(this.timestampField, this.format);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringTimestampExtractionPolicy)) {
            return false;
        }
        StringTimestampExtractionPolicy otherPolicy = (StringTimestampExtractionPolicy)other;
        return Objects.equals(otherPolicy.timestampField, this.timestampField) && Objects.equals(otherPolicy.format, this.format);
    }
}

