/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util.timestamp;

import io.confluent.ksql.GenericRow;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongTimestampExtractor
implements TimestampExtractor {
    private static final Logger log = LoggerFactory.getLogger(LongTimestampExtractor.class);
    private final int timestampColumnindex;

    LongTimestampExtractor(int timestampColumnindex) {
        this.timestampColumnindex = timestampColumnindex;
    }

    public long extract(ConsumerRecord<Object, Object> consumerRecord, long l) {
        if (this.timestampColumnindex < 0) {
            return 0L;
        }
        try {
            GenericRow genericRow;
            if (consumerRecord.value() instanceof GenericRow && (genericRow = (GenericRow)consumerRecord.value()).getColumns().get(this.timestampColumnindex) instanceof Long) {
                return (Long)genericRow.getColumns().get(this.timestampColumnindex);
            }
        }
        catch (Exception e) {
            log.error("Exception in extracting timestamp for row: " + consumerRecord.value(), (Throwable)e);
        }
        return 0L;
    }
}

