/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util.timestamp;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.ColumnRef;
import io.confluent.ksql.util.timestamp.LongTimestampExtractor;
import io.confluent.ksql.util.timestamp.TimestampExtractionPolicy;
import java.util.Objects;
import org.apache.kafka.streams.processor.TimestampExtractor;

@Immutable
public class LongColumnTimestampExtractionPolicy
implements TimestampExtractionPolicy {
    private final ColumnRef timestampField;

    public LongColumnTimestampExtractionPolicy(ColumnRef timestampField) {
        Objects.requireNonNull(timestampField, "timestampField can't be null");
        this.timestampField = timestampField;
    }

    @Override
    public TimestampExtractor create(int columnIndex) {
        return new LongTimestampExtractor(columnIndex);
    }

    @Override
    public ColumnRef timestampField() {
        return this.timestampField;
    }

    public int hashCode() {
        return Objects.hash(this.timestampField);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LongColumnTimestampExtractionPolicy)) {
            return false;
        }
        LongColumnTimestampExtractionPolicy otherPolicy = (LongColumnTimestampExtractionPolicy)other;
        return Objects.equals(otherPolicy.timestampField, this.timestampField);
    }
}

