/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.function.GenericsUtil;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.util.DecimalUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public final class SchemaUtil {
    public static final ColumnName ROWKEY_NAME = ColumnName.of("ROWKEY");
    public static final ColumnName ROWTIME_NAME = ColumnName.of("ROWTIME");
    public static final ColumnName WINDOWSTART_NAME = ColumnName.of("WINDOWSTART");
    public static final int ROWKEY_INDEX = 1;
    private static final Set<Schema.Type> ARITHMETIC_TYPES = ImmutableSet.of((Object)Schema.Type.INT8, (Object)Schema.Type.INT16, (Object)Schema.Type.INT32, (Object)Schema.Type.INT64, (Object)Schema.Type.FLOAT32, (Object)Schema.Type.FLOAT64, (Object[])new Schema.Type[0]);
    private static final char FIELD_NAME_DELIMITER = '.';
    private static final Map<Schema.Type, BiPredicate<Schema, Schema>> CUSTOM_SCHEMA_EQ = ImmutableMap.builder().put((Object)Schema.Type.MAP, SchemaUtil::mapCompatible).put((Object)Schema.Type.ARRAY, SchemaUtil::arrayCompatible).put((Object)Schema.Type.STRUCT, SchemaUtil::structCompatible).put((Object)Schema.Type.BYTES, SchemaUtil::bytesEquals).build();

    private SchemaUtil() {
    }

    public static Class<?> getJavaType(Schema schema) {
        return SchemaConverters.sqlToJavaConverter().toJavaType(SchemaConverters.connectToSqlConverter().toSqlType(schema));
    }

    public static boolean isFieldName(String actual, String required) {
        return required.equals(actual) || required.equals(SchemaUtil.getFieldNameWithNoAlias(actual));
    }

    public static String buildAliasedFieldName(String alias, String fieldName) {
        String prefix = alias + '.';
        if (fieldName.startsWith(prefix)) {
            return fieldName;
        }
        return prefix + fieldName;
    }

    public static String getFieldNameWithNoAlias(String fieldName) {
        int idx = fieldName.indexOf(46);
        if (idx < 0) {
            return fieldName;
        }
        return fieldName.substring(idx + 1);
    }

    public static boolean isNumber(Schema schema) {
        return ARITHMETIC_TYPES.contains(schema.type()) || DecimalUtil.isDecimal(schema);
    }

    public static Schema ensureOptional(Schema schema) {
        SchemaBuilder builder;
        switch (schema.type()) {
            case STRUCT: {
                builder = SchemaBuilder.struct();
                schema.fields().forEach(f -> builder.field(f.name(), SchemaUtil.ensureOptional(f.schema())));
                break;
            }
            case MAP: {
                builder = SchemaBuilder.map((Schema)SchemaUtil.ensureOptional(schema.keySchema()), (Schema)SchemaUtil.ensureOptional(schema.valueSchema()));
                break;
            }
            case ARRAY: {
                builder = SchemaBuilder.array((Schema)SchemaUtil.ensureOptional(schema.valueSchema()));
                break;
            }
            default: {
                if (schema.isOptional()) {
                    return schema;
                }
                builder = new SchemaBuilder(schema.type());
            }
        }
        return builder.name(schema.name()).optional().build();
    }

    public static boolean areCompatible(Schema arg1, Schema arg2) {
        if (arg2 == null) {
            return arg1.isOptional();
        }
        return Objects.equals(arg1.type(), arg2.type()) && CUSTOM_SCHEMA_EQ.getOrDefault(arg1.type(), (a, b) -> true).test(arg1, arg2) && Objects.equals(arg1.version(), arg2.version()) && Objects.deepEquals(arg1.defaultValue(), arg2.defaultValue());
    }

    private static boolean mapCompatible(Schema mapA, Schema mapB) {
        return SchemaUtil.areCompatible(mapA.keySchema(), mapB.keySchema()) && SchemaUtil.areCompatible(mapA.valueSchema(), mapB.valueSchema());
    }

    private static boolean arrayCompatible(Schema arrayA, Schema arrayB) {
        return SchemaUtil.areCompatible(arrayA.valueSchema(), arrayB.valueSchema());
    }

    private static boolean structCompatible(Schema structA, Schema structB) {
        return structA.fields().isEmpty() || structB.fields().isEmpty() || SchemaUtil.compareFieldsOfStructs(structA, structB);
    }

    private static boolean compareFieldsOfStructs(Schema structA, Schema structB) {
        int sizeB;
        List fieldsA = structA.fields();
        List fieldsB = structB.fields();
        int sizeA = fieldsA.size();
        if (sizeA != (sizeB = fieldsB.size())) {
            return false;
        }
        for (int i = 0; i < sizeA; ++i) {
            Field fieldA = (Field)fieldsA.get(i);
            Field fieldB = (Field)fieldsB.get(i);
            if (fieldA.name().equals(fieldB.name()) && fieldA.index() == fieldB.index() && SchemaUtil.areCompatible(((Field)fieldsA.get(i)).schema(), ((Field)fieldsB.get(i)).schema())) continue;
            return false;
        }
        return true;
    }

    private static boolean bytesEquals(Schema bytesA, Schema bytesB) {
        if (GenericsUtil.isGeneric(bytesA)) {
            if (GenericsUtil.isGeneric(bytesB)) {
                return bytesA.name().equals(bytesB.name());
            }
            return false;
        }
        return DecimalUtil.isDecimal(bytesA) && DecimalUtil.isDecimal(bytesB);
    }
}

