/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.connect.SchemaFormatter;
import io.confluent.ksql.schema.connect.SqlSchemaFormatter;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;

@Immutable
public final class QuerySchemas {
    private static final SqlSchemaFormatter FORMATTER = new SqlSchemaFormatter(word -> false, SqlSchemaFormatter.Option.APPEND_NOT_NULL);
    private final LinkedHashMap<String, PersistenceSchema> schemas;
    private final SchemaFormatter schemaFormatter;

    public static QuerySchemas of(LinkedHashMap<String, PersistenceSchema> schemas) {
        return new QuerySchemas(schemas, FORMATTER);
    }

    @VisibleForTesting
    QuerySchemas(LinkedHashMap<String, PersistenceSchema> schemas, SchemaFormatter schemaFormatter) {
        this.schemas = new LinkedHashMap(Objects.requireNonNull(schemas, "schemas"));
        this.schemaFormatter = Objects.requireNonNull(schemaFormatter, "schemaFormatter");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuerySchemas that = (QuerySchemas)o;
        return Objects.equals(this.schemas, that.schemas);
    }

    public int hashCode() {
        return Objects.hash(this.schemas);
    }

    public String toString() {
        return this.schemas.entrySet().stream().map(e -> (String)e.getKey() + " = " + this.schemaFormatter.format((Schema)((PersistenceSchema)e.getValue()).serializedSchema())).collect(Collectors.joining(System.lineSeparator()));
    }
}

