/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.util.KsqlException;

public class KsqlStatementException
extends KsqlException {
    private final String sqlStatement;
    private final String rawMessage;

    public KsqlStatementException(String message, String sqlStatement) {
        super(KsqlStatementException.buildMessage(message, sqlStatement));
        this.rawMessage = message == null ? "" : message;
        this.sqlStatement = sqlStatement == null ? "" : sqlStatement;
    }

    public KsqlStatementException(String message, String sqlStatement, Throwable cause) {
        super(KsqlStatementException.buildMessage(message, sqlStatement), cause);
        this.rawMessage = message == null ? "" : message;
        this.sqlStatement = sqlStatement == null ? "" : sqlStatement;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    private static String buildMessage(String message, String sqlStatement) {
        return message + System.lineSeparator() + "Statement: " + sqlStatement;
    }
}

