/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.WordUtils;

public final class ErrorMessageUtil {
    private static final String PREFIX = "Caused by: ";

    private ErrorMessageUtil() {
    }

    public static String buildErrorMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        List<String> messages = ErrorMessageUtil.getErrorMessages(throwable);
        ErrorMessageUtil.dedup(messages);
        String msg = messages.remove(0);
        String causeMsg = messages.stream().filter(s -> !s.isEmpty()).map(cause -> WordUtils.wrap((String)(PREFIX + cause), (int)80, (String)"\n\t", (boolean)true)).collect(Collectors.joining(System.lineSeparator()));
        return causeMsg.isEmpty() ? msg : msg + System.lineSeparator() + causeMsg;
    }

    public static List<String> getErrorMessages(Throwable e) {
        return ErrorMessageUtil.getThrowables(e).stream().map(ErrorMessageUtil::getErrorMessage).collect(Collectors.toList());
    }

    private static String getErrorMessage(Throwable e) {
        if (e instanceof ConnectException) {
            return "Could not connect to the server.";
        }
        return e.getMessage() == null ? e.toString() : e.getMessage();
    }

    private static List<Throwable> getThrowables(Throwable e) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        for (Throwable cause = e; cause != null && !list.contains(cause); cause = cause.getCause()) {
            list.add(cause);
        }
        return list;
    }

    private static void dedup(List<String> messages) {
        while (messages.size() > 1) {
            if (!messages.get(0).equals(messages.get(1))) {
                return;
            }
            messages.remove(0);
        }
    }
}

