/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.types;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.types.Field;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;

@Immutable
public final class KsqlStruct {
    private final SqlStruct schema;
    private final ImmutableList<Optional<?>> values;

    public static Builder builder(SqlStruct schema) {
        return new Builder(schema);
    }

    private KsqlStruct(SqlStruct schema, List<Optional<?>> values) {
        this.schema = Objects.requireNonNull(schema, "schema");
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values"));
    }

    public SqlStruct schema() {
        return this.schema;
    }

    public List<Optional<?>> values() {
        return this.values;
    }

    public void forEach(BiConsumer<? super Field, ? super Optional<?>> consumer) {
        for (int idx = 0; idx < this.values.size(); ++idx) {
            Field field = this.schema.fields().get(idx);
            Optional value = (Optional)this.values.get(idx);
            consumer.accept(field, value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlStruct that = (KsqlStruct)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.values);
    }

    public String toString() {
        return "KsqlStruct{values=" + this.values + ", schema=" + this.schema + '}';
    }

    private static FieldInfo getField(String name, SqlStruct schema) {
        List<Field> fields = schema.fields();
        for (int idx = 0; idx < fields.size(); ++idx) {
            Field field = fields.get(idx);
            if (!field.name().equals(name)) continue;
            return new FieldInfo(idx, field);
        }
        throw new KsqlException("Unknown field: " + name);
    }

    private static final class FieldInfo {
        final int index;
        final Field field;

        private FieldInfo(int index, Field field) {
            this.index = index;
            this.field = Objects.requireNonNull(field, "field");
        }
    }

    public static final class Builder {
        private final SqlStruct schema;
        private final List<Optional<?>> values;

        public Builder(SqlStruct schema) {
            this.schema = Objects.requireNonNull(schema, "schema");
            this.values = new ArrayList(schema.fields().size());
            schema.fields().forEach(f -> this.values.add(Optional.empty()));
        }

        public Builder set(String field, Optional<?> value) {
            FieldInfo info = KsqlStruct.getField(field, this.schema);
            info.field.type().validateValue(value.orElse(null));
            this.values.set(info.index, value);
            return this;
        }

        public KsqlStruct build() {
            return new KsqlStruct(this.schema, this.values);
        }
    }
}

