/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatInfo;
import java.util.Objects;

@Immutable
public final class ValueFormat {
    private final FormatInfo format;

    public static ValueFormat of(FormatInfo format) {
        return new ValueFormat(format);
    }

    private ValueFormat(FormatInfo format) {
        this.format = Objects.requireNonNull(format, "format");
    }

    public Format getFormat() {
        return this.format.getFormat();
    }

    public FormatInfo getFormatInfo() {
        return this.format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueFormat that = (ValueFormat)o;
        return Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }

    public String toString() {
        return "ValueFormat{format=" + this.format + '}';
    }
}

