/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.WindowInfo;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class KeyFormat {
    private final FormatInfo format;
    private final Optional<WindowInfo> window;

    public static KeyFormat nonWindowed(FormatInfo format) {
        return new KeyFormat(format, Optional.empty());
    }

    public static KeyFormat windowed(FormatInfo format, WindowInfo windowInfo) {
        return new KeyFormat(format, Optional.of(windowInfo));
    }

    private KeyFormat(FormatInfo format, Optional<WindowInfo> window) {
        this.format = Objects.requireNonNull(format, "format");
        this.window = Objects.requireNonNull(window, "window");
    }

    public Format getFormat() {
        return this.format.getFormat();
    }

    public FormatInfo getFormatInfo() {
        return this.format;
    }

    public boolean isWindowed() {
        return this.window.isPresent();
    }

    public Optional<WindowInfo> getWindowInfo() {
        return this.window;
    }

    public Optional<WindowType> getWindowType() {
        return this.window.map(WindowInfo::getType);
    }

    public Optional<Duration> getWindowSize() {
        return this.window.flatMap(WindowInfo::getSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyFormat keyFormat = (KeyFormat)o;
        return Objects.equals(this.format, keyFormat.format) && Objects.equals(this.window, keyFormat.window);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.window);
    }

    public String toString() {
        return "KeyFormat{format=" + this.format + ", window=" + this.window + '}';
    }
}

