/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.serde.Delimiter;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class FormatInfo {
    private final Format format;
    private final Optional<String> avroFullSchemaName;
    private final Optional<Delimiter> delimiter;

    public static FormatInfo of(Format format) {
        return FormatInfo.of(format, Optional.empty(), Optional.empty());
    }

    public static FormatInfo of(Format format, Optional<String> avroFullSchemaName, Optional<Delimiter> valueDelimiter) {
        return new FormatInfo(format, avroFullSchemaName, valueDelimiter);
    }

    private FormatInfo(Format format, Optional<String> avroFullSchemaName, Optional<Delimiter> delimiter) {
        this.format = Objects.requireNonNull(format, "format");
        this.avroFullSchemaName = Objects.requireNonNull(avroFullSchemaName, "avroFullSchemaName");
        if (format != Format.AVRO && avroFullSchemaName.isPresent()) {
            throw new KsqlException("Full schema name only supported with AVRO format");
        }
        if (format == Format.AVRO && avroFullSchemaName.map(name -> name.trim().isEmpty()).orElse(false).booleanValue()) {
            throw new KsqlException("Schema name cannot be empty");
        }
        this.delimiter = Objects.requireNonNull(delimiter, "delimiter");
        if (format != Format.DELIMITED && delimiter.isPresent()) {
            throw new KsqlException("Delimeter only supported with DELIMITED format");
        }
    }

    public Format getFormat() {
        return this.format;
    }

    public Optional<String> getAvroFullSchemaName() {
        return this.avroFullSchemaName;
    }

    public Optional<Delimiter> getDelimiter() {
        return this.delimiter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormatInfo that = (FormatInfo)o;
        return this.format == that.format && Objects.equals(this.avroFullSchemaName, that.avroFullSchemaName) && Objects.equals(this.delimiter, that.delimiter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.avroFullSchemaName, this.delimiter});
    }

    public String toString() {
        return "FormatInfo{format=" + (Object)((Object)this.format) + ", avroFullSchemaName=" + this.avroFullSchemaName + ", delimiter=" + this.delimiter + '}';
    }
}

