/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import io.confluent.ksql.util.KsqlException;

public enum Format {
    JSON(true),
    AVRO(true),
    DELIMITED(false),
    KAFKA(false);

    private final boolean supportsUnwrapping;

    private Format(boolean supportsUnwrapping) {
        this.supportsUnwrapping = supportsUnwrapping;
    }

    public boolean supportsUnwrapping() {
        return this.supportsUnwrapping;
    }

    public static Format of(String value) {
        try {
            return Format.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new KsqlException("Unknown format: " + value);
        }
    }
}

