/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Immutable
public final class Delimiter {
    private static final Map<String, Character> NAMED_DELIMITERS = ImmutableMap.builder().put((Object)"TAB", (Object)Character.valueOf('\t')).put((Object)"SPACE", (Object)Character.valueOf(' ')).build();
    private static final String NAMED_DELIMITERS_STRING = StringUtils.join(NAMED_DELIMITERS.keySet(), (String)",");
    private final char delimiter;

    private Delimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public static Delimiter of(char ch) {
        return new Delimiter(ch);
    }

    public static Delimiter parse(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        if (str.trim().isEmpty()) {
            throw new IllegalArgumentException("Delimiter cannot be empty, if you meant to have a tab or space for delimiter, please use the special values 'TAB' or 'SPACE'" + System.lineSeparator() + "Example valid value: ';'");
        }
        if (str.length() == 1) {
            return new Delimiter(str.charAt(0));
        }
        Character delim = NAMED_DELIMITERS.get(str);
        if (delim != null) {
            return new Delimiter(delim.charValue());
        }
        throw new IllegalArgumentException("Invalid delimiter value: '" + str + "'. Delimiter must be a single character or " + NAMED_DELIMITERS_STRING + System.lineSeparator() + "Example valid value: ';'");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Delimiter delimiter1 = (Delimiter)o;
        return this.delimiter == delimiter1.delimiter;
    }

    public int hashCode() {
        return Objects.hash(Character.valueOf(this.delimiter));
    }

    public String toString() {
        return String.valueOf(this.delimiter);
    }

    public char getDelimiter() {
        return this.delimiter;
    }
}

