/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.DataException;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.Field;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.types.KsqlStruct;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Immutable
public final class SqlStruct
extends SqlType {
    private static final String PREFIX = "STRUCT<";
    private static final String POSTFIX = ">";
    private static final String EMPTY_STRUCT = "STRUCT< >";
    private final ImmutableList<Field> fields;
    private final ImmutableMap<String, Field> byName;

    public static Builder builder() {
        return new Builder();
    }

    private SqlStruct(List<Field> fields, Map<String, Field> byName) {
        super(SqlBaseType.STRUCT);
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields"));
        this.byName = ImmutableMap.copyOf(Objects.requireNonNull(byName, "byName"));
    }

    public List<Field> fields() {
        return this.fields;
    }

    public Optional<Field> field(String name) {
        return Optional.ofNullable(this.byName.get((Object)name));
    }

    @Override
    public boolean supportsCast() {
        return false;
    }

    @Override
    public void validateValue(Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof KsqlStruct)) {
            SqlBaseType sqlBaseType = SchemaConverters.javaToSqlConverter().toSqlType(value.getClass());
            throw new DataException("Expected STRUCT, got " + (Object)((Object)sqlBaseType));
        }
        KsqlStruct struct = (KsqlStruct)value;
        if (!struct.schema().equals(this)) {
            throw new DataException("Expected " + this + ", got " + struct.schema());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlStruct struct = (SqlStruct)o;
        return this.fields.equals(struct.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    @Override
    public String toString(FormatOptions formatOptions) {
        if (this.fields.isEmpty()) {
            return EMPTY_STRUCT;
        }
        return this.fields.stream().map(f -> f.toString(formatOptions)).collect(Collectors.joining(", ", PREFIX, POSTFIX));
    }

    public static final class Builder {
        private final List<Field> fields = new ArrayList<Field>();
        private final Map<String, Field> byName = new HashMap<String, Field>();

        public Builder field(String fieldName, SqlType fieldType) {
            return this.field(Field.of(fieldName, fieldType));
        }

        public Builder field(Field field) {
            if (this.byName.putIfAbsent(field.name(), field) != null) {
                throw new KsqlException("Duplicate field names found in STRUCT: '" + this.byName.get(field.name()) + "' and '" + field + "'");
            }
            this.fields.add(field);
            return this;
        }

        public Builder fields(Iterable<? extends Field> fields) {
            fields.forEach(this::field);
            return this;
        }

        public SqlStruct build() {
            return new SqlStruct(this.fields, this.byName);
        }
    }
}

