/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.DataException;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import java.util.Map;
import java.util.Objects;

@Immutable
public final class SqlMap
extends SqlType {
    private static final SqlType KEY_TYPE = SqlTypes.STRING;
    private final SqlType valueType;

    public static SqlMap of(SqlType valueType) {
        return new SqlMap(valueType);
    }

    private SqlMap(SqlType valueType) {
        super(SqlBaseType.MAP);
        this.valueType = Objects.requireNonNull(valueType, "valueType");
    }

    public SqlType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean supportsCast() {
        return false;
    }

    @Override
    public void validateValue(Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            SqlBaseType sqlBaseType = SchemaConverters.javaToSqlConverter().toSqlType(value.getClass());
            throw new DataException("Expected MAP, got " + (Object)((Object)sqlBaseType));
        }
        Map map = (Map)value;
        map.forEach((k, v) -> {
            try {
                KEY_TYPE.validateValue(k);
            }
            catch (DataException e) {
                throw new DataException("MAP key: " + e.getMessage(), e);
            }
            try {
                this.valueType.validateValue(v);
            }
            catch (DataException e) {
                throw new DataException("MAP value for key '" + k + "': " + e.getMessage(), e);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlMap map = (SqlMap)o;
        return Objects.equals(this.valueType, map.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.valueType);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    @Override
    public String toString(FormatOptions formatOptions) {
        return "MAP<" + SqlTypes.STRING + ", " + this.valueType.toString(formatOptions) + '>';
    }
}

