/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.DataException;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.DecimalUtil;
import java.math.BigDecimal;
import java.util.Objects;

@Immutable
public final class SqlDecimal
extends SqlType {
    private final int precision;
    private final int scale;

    public static SqlDecimal of(int precision, int scale) {
        return new SqlDecimal(precision, scale);
    }

    private SqlDecimal(int precision, int scale) {
        super(SqlBaseType.DECIMAL);
        this.precision = precision;
        this.scale = scale;
        DecimalUtil.validateParameters(precision, scale);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public boolean supportsCast() {
        return true;
    }

    @Override
    public void validateValue(Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof BigDecimal)) {
            SqlBaseType sqlBaseType = SchemaConverters.javaToSqlConverter().toSqlType(value.getClass());
            throw new DataException("Expected DECIMAL, got " + (Object)((Object)sqlBaseType));
        }
        BigDecimal decimal = (BigDecimal)value;
        if (decimal.precision() != this.precision) {
            throw new DataException("Expected " + this + ", got precision " + decimal.precision());
        }
        if (decimal.scale() != this.scale) {
            throw new DataException("Expected " + this + ", got scale " + decimal.scale());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlDecimal that = (SqlDecimal)o;
        return this.precision == that.precision && this.scale == that.scale;
    }

    public int hashCode() {
        return Objects.hash(this.precision, this.scale);
    }

    public String toString() {
        return "DECIMAL(" + this.precision + ", " + this.scale + ')';
    }

    @Override
    public String toString(FormatOptions formatOptions) {
        return this.toString();
    }

    public static SqlDecimal add(SqlDecimal left, SqlDecimal right) {
        int precision = Math.max(left.scale, right.scale) + Math.max(left.precision - left.scale, right.precision - right.scale) + 1;
        int scale = Math.max(left.scale, right.scale);
        return SqlDecimal.of(precision, scale);
    }

    public static SqlDecimal subtract(SqlDecimal left, SqlDecimal right) {
        return SqlDecimal.add(left, right);
    }

    public static SqlDecimal multiply(SqlDecimal left, SqlDecimal right) {
        int precision = left.precision + right.precision + 1;
        int scale = left.scale + right.scale;
        return SqlDecimal.of(precision, scale);
    }

    public static SqlDecimal divide(SqlDecimal left, SqlDecimal right) {
        int precision = left.precision - left.scale + right.scale + Math.max(6, left.scale + right.precision + 1);
        int scale = Math.max(6, left.scale + right.precision + 1);
        return SqlDecimal.of(precision, scale);
    }

    public static SqlDecimal modulus(SqlDecimal left, SqlDecimal right) {
        int precision = Math.min(left.precision - left.scale, right.precision - right.scale) + Math.max(left.scale, right.scale);
        int scale = Math.max(left.scale, right.scale);
        return SqlDecimal.of(precision, scale);
    }
}

