/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.DataException;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

@Immutable
public final class SqlArray
extends SqlType {
    private final SqlType itemType;

    public static SqlArray of(SqlType itemType) {
        return new SqlArray(itemType);
    }

    private SqlArray(SqlType itemType) {
        super(SqlBaseType.ARRAY);
        this.itemType = Objects.requireNonNull(itemType, "itemType");
    }

    public SqlType getItemType() {
        return this.itemType;
    }

    @Override
    public boolean supportsCast() {
        return false;
    }

    @Override
    public void validateValue(Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof List)) {
            SqlBaseType sqlBaseType = SchemaConverters.javaToSqlConverter().toSqlType(value.getClass());
            throw new DataException("Expected ARRAY, got " + (Object)((Object)sqlBaseType));
        }
        List array = (List)value;
        IntStream.range(0, array.size()).forEach(idx -> {
            try {
                Object element = array.get(idx);
                this.itemType.validateValue(element);
            }
            catch (DataException e) {
                throw new DataException("ARRAY element " + (idx + 1) + ": " + e.getMessage(), e);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlArray array = (SqlArray)o;
        return Objects.equals(this.itemType, array.itemType);
    }

    public int hashCode() {
        return Objects.hash(this.itemType);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    @Override
    public String toString(FormatOptions formatOptions) {
        return "ARRAY<" + this.itemType.toString(formatOptions) + '>';
    }
}

