/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.Identifiers;
import java.util.Objects;

@Immutable
public final class Field {
    private final String name;
    private final SqlType type;

    public static Field of(String name, SqlType type) {
        return new Field(name, type);
    }

    private Field(String name, SqlType type) {
        this.name = Identifiers.ensureTrimmed(Objects.requireNonNull(name, "name"), "name");
        this.type = Objects.requireNonNull(type, "type");
    }

    public SqlType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field that = (Field)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    public String toString(FormatOptions formatOptions) {
        return Identifiers.escape(this.name, formatOptions) + " " + this.type.toString(formatOptions);
    }
}

