/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.schema.ksql.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public final class SchemaConverters {
    private static final ConnectToSqlTypeConverter CONNECT_TO_SQL_CONVERTER = new ConnectToSqlConverter();
    private static final SqlToConnectTypeConverter SQL_TO_CONNECT_CONVERTER = new ConnectFromSqlConverter();
    private static final JavaToSqlTypeConverter JAVA_TO_SQL_CONVERTER = new JavaToSqlConverter();
    private static final SqlToJavaTypeConverter SQL_TO_JAVA_CONVERTER = new SqlToJavaConverter();

    private SchemaConverters() {
    }

    public static ConnectToSqlTypeConverter connectToSqlConverter() {
        return CONNECT_TO_SQL_CONVERTER;
    }

    public static SqlToConnectTypeConverter sqlToConnectConverter() {
        return SQL_TO_CONNECT_CONVERTER;
    }

    public static JavaToSqlTypeConverter javaToSqlConverter() {
        return JAVA_TO_SQL_CONVERTER;
    }

    public static SqlToJavaTypeConverter sqlToJavaConverter() {
        return SQL_TO_JAVA_CONVERTER;
    }

    private static class SqlToJavaConverter
    implements SqlToJavaTypeConverter {
        private static final BiMap<SqlBaseType, Class<?>> SQL_TO_JAVA = JavaToSqlConverter.access$400().inverse();

        private SqlToJavaConverter() {
        }

        @Override
        public Class<?> toJavaType(SqlBaseType sqlBaseType) {
            Class javaType = (Class)SQL_TO_JAVA.get((Object)sqlBaseType);
            if (javaType == null) {
                throw new KsqlException("Unexpected sql type: " + (Object)((Object)sqlBaseType));
            }
            return javaType;
        }
    }

    private static class JavaToSqlConverter
    implements JavaToSqlTypeConverter {
        private static final BiMap<Class<?>, SqlBaseType> JAVA_TO_SQL = ImmutableBiMap.builder().put(Boolean.class, (Object)SqlBaseType.BOOLEAN).put(Integer.class, (Object)SqlBaseType.INTEGER).put(Long.class, (Object)SqlBaseType.BIGINT).put(Double.class, (Object)SqlBaseType.DOUBLE).put(String.class, (Object)SqlBaseType.STRING).put(BigDecimal.class, (Object)SqlBaseType.DECIMAL).put(List.class, (Object)SqlBaseType.ARRAY).put(Map.class, (Object)SqlBaseType.MAP).put(Struct.class, (Object)SqlBaseType.STRUCT).build();

        private JavaToSqlConverter() {
        }

        @Override
        public SqlBaseType toSqlType(Class<?> javaType) {
            return JAVA_TO_SQL.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(javaType)).map(Map.Entry::getValue).findAny().orElseThrow(() -> new KsqlException("Unexpected java type: " + javaType));
        }

        static /* synthetic */ BiMap access$400() {
            return JAVA_TO_SQL;
        }
    }

    private static final class ConnectFromSqlConverter
    implements SqlToConnectTypeConverter {
        private static final Map<SqlBaseType, Function<SqlType, SchemaBuilder>> SQL_TO_CONNECT = ImmutableMap.builder().put((Object)SqlBaseType.STRING, t -> SchemaBuilder.string().optional()).put((Object)SqlBaseType.BOOLEAN, t -> SchemaBuilder.bool().optional()).put((Object)SqlBaseType.INTEGER, t -> SchemaBuilder.int32().optional()).put((Object)SqlBaseType.BIGINT, t -> SchemaBuilder.int64().optional()).put((Object)SqlBaseType.DOUBLE, t -> SchemaBuilder.float64().optional()).put((Object)SqlBaseType.DECIMAL, t -> ConnectFromSqlConverter.fromSqlDecimal((SqlDecimal)t)).put((Object)SqlBaseType.ARRAY, t -> ConnectFromSqlConverter.fromSqlArray((SqlArray)t)).put((Object)SqlBaseType.MAP, t -> ConnectFromSqlConverter.fromSqlMap((SqlMap)t)).put((Object)SqlBaseType.STRUCT, t -> ConnectFromSqlConverter.fromSqlStruct((SqlStruct)t)).build();

        private ConnectFromSqlConverter() {
        }

        @Override
        public Schema toConnectSchema(SqlType type) {
            return ConnectFromSqlConverter.connectType(type).build();
        }

        @Override
        public Schema toConnectSchema(SqlType type, String name, String doc) {
            return ConnectFromSqlConverter.connectType(type).name(name).doc(doc).build();
        }

        private static SchemaBuilder connectType(SqlType sqlType) {
            Function<SqlType, SchemaBuilder> handler = SQL_TO_CONNECT.get((Object)sqlType.baseType());
            if (handler == null) {
                throw new KsqlException("Unexpected sql type: " + sqlType);
            }
            return handler.apply(sqlType);
        }

        private static SchemaBuilder fromSqlDecimal(SqlDecimal sqlDecimal) {
            return DecimalUtil.builder(sqlDecimal.getPrecision(), sqlDecimal.getScale());
        }

        private static SchemaBuilder fromSqlArray(SqlArray sqlArray) {
            return SchemaBuilder.array((Schema)ConnectFromSqlConverter.connectType(sqlArray.getItemType()).build()).optional();
        }

        private static SchemaBuilder fromSqlMap(SqlMap sqlMap) {
            return SchemaBuilder.map((Schema)Schema.OPTIONAL_STRING_SCHEMA, (Schema)ConnectFromSqlConverter.connectType(sqlMap.getValueType()).build()).optional();
        }

        private static SchemaBuilder fromSqlStruct(SqlStruct struct) {
            SchemaBuilder builder = SchemaBuilder.struct();
            struct.fields().forEach(field -> builder.field(field.name(), ConnectFromSqlConverter.connectType(field.type()).build()));
            return builder.optional();
        }
    }

    private static final class ConnectToSqlConverter
    implements ConnectToSqlTypeConverter {
        private static final Map<Schema.Type, Function<Schema, SqlType>> CONNECT_TO_SQL = ImmutableMap.builder().put((Object)Schema.Type.INT32, s -> SqlTypes.INTEGER).put((Object)Schema.Type.INT64, s -> SqlTypes.BIGINT).put((Object)Schema.Type.FLOAT64, s -> SqlTypes.DOUBLE).put((Object)Schema.Type.BOOLEAN, s -> SqlTypes.BOOLEAN).put((Object)Schema.Type.STRING, s -> SqlTypes.STRING).put((Object)Schema.Type.ARRAY, ConnectToSqlConverter::toSqlArray).put((Object)Schema.Type.MAP, ConnectToSqlConverter::toSqlMap).put((Object)Schema.Type.STRUCT, ConnectToSqlConverter::toSqlStruct).put((Object)Schema.Type.BYTES, ConnectToSqlConverter::handleBytes).build();

        private ConnectToSqlConverter() {
        }

        @Override
        public SqlType toSqlType(Schema schema) {
            return ConnectToSqlConverter.sqlType(schema);
        }

        private static SqlType sqlType(Schema schema) {
            Function<Schema, SqlType> handler = CONNECT_TO_SQL.get(schema.type());
            if (handler == null) {
                throw new KsqlException("Unexpected schema type: " + schema);
            }
            return handler.apply(schema);
        }

        private static SqlDecimal handleBytes(Schema schema) {
            DecimalUtil.requireDecimal(schema);
            return SqlDecimal.of(DecimalUtil.precision(schema), DecimalUtil.scale(schema));
        }

        private static SqlArray toSqlArray(Schema schema) {
            return SqlArray.of(ConnectToSqlConverter.sqlType(schema.valueSchema()));
        }

        private static SqlMap toSqlMap(Schema schema) {
            if (schema.keySchema().type() != Schema.Type.STRING) {
                throw new KsqlException("Unsupported map key type: " + schema.keySchema());
            }
            return SqlMap.of(ConnectToSqlConverter.sqlType(schema.valueSchema()));
        }

        private static SqlStruct toSqlStruct(Schema schema) {
            SqlStruct.Builder builder = SqlStruct.builder();
            schema.schema().fields().forEach(field -> builder.field(field.name(), ConnectToSqlConverter.sqlType(field.schema())));
            return builder.build();
        }
    }

    public static interface SqlToJavaTypeConverter {
        public Class<?> toJavaType(SqlBaseType var1);

        default public Class<?> toJavaType(SqlType sqlType) {
            return this.toJavaType(sqlType.baseType());
        }
    }

    public static interface JavaToSqlTypeConverter {
        public SqlBaseType toSqlType(Class<?> var1);
    }

    public static interface SqlToConnectTypeConverter {
        public Schema toConnectSchema(SqlType var1);

        public Schema toConnectSchema(SqlType var1, String var2, String var3);
    }

    public static interface ConnectToSqlTypeConverter {
        public SqlType toSqlType(Schema var1);
    }
}

