/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.connect.SqlSchemaFormatter;
import java.util.Objects;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

@Immutable
public final class PersistenceSchema {
    private static final SqlSchemaFormatter FORMATTER = new SqlSchemaFormatter(word -> false, SqlSchemaFormatter.Option.APPEND_NOT_NULL);
    private final boolean unwrapped;
    private final ConnectSchema ksqlSchema;
    private final ConnectSchema serializedSchema;

    public static PersistenceSchema from(ConnectSchema ksqlSchema, boolean unwrapSingle) {
        return new PersistenceSchema(ksqlSchema, unwrapSingle);
    }

    private PersistenceSchema(ConnectSchema ksqlSchema, boolean unwrapSingle) {
        boolean singleField;
        this.unwrapped = unwrapSingle;
        this.ksqlSchema = Objects.requireNonNull(ksqlSchema, "ksqlSchema");
        if (ksqlSchema.type() != Schema.Type.STRUCT) {
            throw new IllegalArgumentException("Expected STRUCT schema type");
        }
        boolean bl = singleField = ksqlSchema.fields().size() == 1;
        if (unwrapSingle && !singleField) {
            throw new IllegalArgumentException("Unwrapping only valid for single field");
        }
        this.serializedSchema = unwrapSingle ? (ConnectSchema)((Field)ksqlSchema.fields().get(0)).schema() : ksqlSchema;
    }

    public boolean isUnwrapped() {
        return this.unwrapped;
    }

    public ConnectSchema ksqlSchema() {
        return this.ksqlSchema;
    }

    public ConnectSchema serializedSchema() {
        return this.serializedSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistenceSchema that = (PersistenceSchema)o;
        return this.unwrapped == that.unwrapped && Objects.equals(this.serializedSchema, that.serializedSchema);
    }

    public int hashCode() {
        return Objects.hash(this.unwrapped, this.serializedSchema);
    }

    public String toString() {
        return "Persistence{schema=" + FORMATTER.format((Schema)this.serializedSchema) + ", unwrapped=" + this.unwrapped + '}';
    }
}

