/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.ColumnRef;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.SchemaUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

@Immutable
public final class LogicalSchema {
    private static final NamespacedColumn IMPLICIT_TIME_COLUMN = NamespacedColumn.of(Column.of(SchemaUtil.ROWTIME_NAME, (SqlType)SqlTypes.BIGINT), Namespace.META);
    private static final NamespacedColumn IMPLICIT_KEY_COLUMN = NamespacedColumn.of(Column.of(SchemaUtil.ROWKEY_NAME, (SqlType)SqlTypes.STRING), Namespace.KEY);
    private final ImmutableList<NamespacedColumn> columns;

    public static Builder builder() {
        return new Builder();
    }

    private LogicalSchema(ImmutableList<NamespacedColumn> columns) {
        this.columns = Objects.requireNonNull(columns, "columns");
    }

    public ConnectSchema keyConnectSchema() {
        return LogicalSchema.toConnectSchema(this.key());
    }

    public ConnectSchema valueConnectSchema() {
        return LogicalSchema.toConnectSchema(this.value());
    }

    public List<Column> metadata() {
        return this.byNamespace(NamespacedColumn::column).get((Object)Namespace.META);
    }

    public List<Column> key() {
        return this.byNamespace(NamespacedColumn::column).get((Object)Namespace.KEY);
    }

    public List<Column> value() {
        return this.byNamespace(NamespacedColumn::column).get((Object)Namespace.VALUE);
    }

    public List<Column> columns() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.columns.forEach(c -> builder.add((Object)c.column()));
        return builder.build();
    }

    public Optional<Column> findColumn(ColumnRef target) {
        return this.findNamespacedColumn(LogicalSchema.thatMatches(target)).map(NamespacedColumn::column);
    }

    public Optional<Column> findValueColumn(ColumnRef target) {
        return this.findNamespacedColumn(LogicalSchema.withNamespace(Namespace.VALUE).and(LogicalSchema.thatMatches(target))).map(NamespacedColumn::column);
    }

    public OptionalInt valueColumnIndex(ColumnRef target) {
        int idx = 0;
        for (Column column : this.value()) {
            if (column.matches(target)) {
                return OptionalInt.of(idx);
            }
            ++idx;
        }
        return OptionalInt.empty();
    }

    public LogicalSchema withAlias(SourceName alias) {
        if (this.isAliased()) {
            throw new IllegalStateException("Already aliased");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        this.columns.stream().map(c -> c.withSource(alias)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return new LogicalSchema((ImmutableList<NamespacedColumn>)builder.build());
    }

    public LogicalSchema withoutAlias() {
        if (!this.isAliased()) {
            throw new IllegalStateException("Not aliased");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        this.columns.stream().map(NamespacedColumn::noSource).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return new LogicalSchema((ImmutableList<NamespacedColumn>)builder.build());
    }

    public boolean isAliased() {
        return ((NamespacedColumn)this.columns.get(0)).column().source().isPresent();
    }

    public LogicalSchema withMetaAndKeyColsInValue() {
        return this.rebuild(true);
    }

    public LogicalSchema withoutMetaAndKeyColsInValue() {
        return this.rebuild(false);
    }

    public boolean isMetaColumn(ColumnName columnName) {
        return this.findNamespacedColumn(LogicalSchema.withNamespace(Namespace.META).and(LogicalSchema.withName(columnName))).isPresent();
    }

    public boolean isKeyColumn(ColumnName columnName) {
        return this.findNamespacedColumn(LogicalSchema.withNamespace(Namespace.KEY).and(LogicalSchema.withName(columnName))).isPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalSchema that = (LogicalSchema)o;
        return Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.columns);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    public String toString(FormatOptions formatOptions) {
        return this.columns.stream().filter(LogicalSchema.withNamespace(Namespace.META).negate()).map(c -> c.toString(formatOptions)).collect(Collectors.joining(", ", "[", "]"));
    }

    private Optional<NamespacedColumn> findNamespacedColumn(Predicate<NamespacedColumn> predicate) {
        return this.columns.stream().filter(predicate).findFirst();
    }

    private <T> Map<Namespace, List<T>> byNamespace(Function<NamespacedColumn, T> mapper) {
        Map byNamespace = this.columns.stream().collect(Collectors.groupingBy(NamespacedColumn::namespace, Collectors.mapping(mapper, Collectors.toList())));
        Arrays.stream(Namespace.values()).forEach(ns -> {
            List cfr_ignored_0 = (List)byNamespace.putIfAbsent((Namespace)((Object)ns), ImmutableList.of());
        });
        return byNamespace;
    }

    private LogicalSchema rebuild(boolean withMetaAndKeyColsInValue) {
        Map byNamespace = this.byNamespace(Function.identity());
        List metadata = byNamespace.get((Object)Namespace.META);
        List key = byNamespace.get((Object)Namespace.KEY);
        List value = byNamespace.get((Object)Namespace.VALUE);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(metadata);
        builder.addAll(key);
        if (withMetaAndKeyColsInValue) {
            metadata.stream().map(c -> NamespacedColumn.of(c.column(), Namespace.VALUE)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            key.stream().map(c -> NamespacedColumn.of(c.column(), Namespace.VALUE)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        value.stream().filter(c -> !this.findNamespacedColumn(LogicalSchema.withNamespace(Namespace.META).or(LogicalSchema.withNamespace(Namespace.KEY)).and(LogicalSchema.thatMatches(c.column().ref()))).isPresent()).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return new LogicalSchema((ImmutableList<NamespacedColumn>)builder.build());
    }

    private static Predicate<NamespacedColumn> thatMatches(ColumnRef ref) {
        return c -> c.column().matches(ref);
    }

    private static Predicate<NamespacedColumn> withName(ColumnName name) {
        return c -> c.column().matches(ColumnRef.withoutSource(name));
    }

    private static Predicate<NamespacedColumn> withNamespace(Namespace ns) {
        return c -> c.namespace() == ns;
    }

    private static ConnectSchema toConnectSchema(List<Column> columns) {
        SchemaConverters.SqlToConnectTypeConverter converter = SchemaConverters.sqlToConnectConverter();
        SchemaBuilder builder = SchemaBuilder.struct();
        for (Column column : columns) {
            Schema colSchema = converter.toConnectSchema(column.type());
            builder.field(column.ref().aliasedFieldName(), colSchema);
        }
        return (ConnectSchema)builder.build();
    }

    @Immutable
    private static final class NamespacedColumn {
        private final Column column;
        private final Namespace namespace;

        static NamespacedColumn of(Column column, Namespace namespace) {
            return new NamespacedColumn(column, namespace);
        }

        private NamespacedColumn(Column column, Namespace namespace) {
            this.column = Objects.requireNonNull(column, "column");
            this.namespace = Objects.requireNonNull(namespace, "namespace");
        }

        Column column() {
            return this.column;
        }

        Namespace namespace() {
            return this.namespace;
        }

        NamespacedColumn withSource(SourceName sourceName) {
            return NamespacedColumn.of(this.column.withSource(sourceName), this.namespace);
        }

        NamespacedColumn noSource() {
            return NamespacedColumn.of(Column.of(this.column.name(), this.column.type()), this.namespace);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamespacedColumn that = (NamespacedColumn)o;
            return Objects.equals(this.column, that.column) && this.namespace == that.namespace;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.column, this.namespace});
        }

        public String toString() {
            return this.toString(FormatOptions.none());
        }

        public String toString(FormatOptions formatOptions) {
            String postFix = this.namespace == Namespace.VALUE ? "" : " " + (Object)((Object)this.namespace);
            return this.column.toString(formatOptions) + postFix;
        }
    }

    private static enum Namespace {
        META,
        KEY,
        VALUE;

    }

    public static class Builder {
        private final ImmutableList.Builder<NamespacedColumn> explicitColumns = ImmutableList.builder();
        private final Set<ColumnRef> seenKeys = new HashSet<ColumnRef>();
        private final Set<ColumnRef> seenValues = new HashSet<ColumnRef>();
        private boolean addImplicitRowKey = true;
        private boolean addImplicitRowTime = true;

        public Builder noImplicitColumns() {
            this.addImplicitRowKey = false;
            this.addImplicitRowTime = false;
            return this;
        }

        public Builder keyColumn(ColumnName columnName, SqlType type) {
            this.keyColumn(Column.of(columnName, type));
            return this;
        }

        public Builder keyColumn(Column column) {
            if (!this.seenKeys.add(column.ref())) {
                throw new KsqlException("Duplicate keys found in schema: " + column);
            }
            this.explicitColumns.add((Object)NamespacedColumn.of(column, Namespace.KEY));
            this.addImplicitRowKey = false;
            return this;
        }

        public Builder keyColumns(Iterable<? extends Column> columns) {
            columns.forEach(this::keyColumn);
            return this;
        }

        public Builder valueColumn(ColumnName columnName, SqlType type) {
            this.valueColumn(Column.of(columnName, type));
            return this;
        }

        public Builder valueColumn(SourceName source, ColumnName name, SqlType type) {
            this.valueColumn(Column.of(source, name, type));
            return this;
        }

        public Builder valueColumn(Column column) {
            if (!this.seenValues.add(column.ref())) {
                throw new KsqlException("Duplicate values found in schema: " + column);
            }
            this.explicitColumns.add((Object)NamespacedColumn.of(column, Namespace.VALUE));
            return this;
        }

        public Builder valueColumns(Iterable<? extends Column> column) {
            column.forEach(this::valueColumn);
            return this;
        }

        public LogicalSchema build() {
            ImmutableList.Builder allColumns = ImmutableList.builder();
            if (this.addImplicitRowTime) {
                allColumns.add((Object)IMPLICIT_TIME_COLUMN);
            }
            if (this.addImplicitRowKey) {
                allColumns.add((Object)IMPLICIT_KEY_COLUMN);
            }
            allColumns.addAll((Iterable)this.explicitColumns.build());
            return new LogicalSchema(allColumns.build());
        }
    }
}

