/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.util.SchemaUtil;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class ColumnRef {
    private final Optional<SourceName> qualifier;
    private final ColumnName name;

    public static ColumnRef of(Optional<SourceName> qualifier, ColumnName name) {
        return new ColumnRef(qualifier, name);
    }

    public static ColumnRef of(SourceName qualifier, ColumnName name) {
        return ColumnRef.of(Optional.of(qualifier), name);
    }

    public static ColumnRef withoutSource(ColumnName name) {
        return new ColumnRef(Optional.empty(), name);
    }

    private ColumnRef(Optional<SourceName> qualifier, ColumnName name) {
        this.qualifier = Objects.requireNonNull(qualifier, "qualifier");
        this.name = Objects.requireNonNull(name, "name");
    }

    public Optional<SourceName> source() {
        return this.qualifier;
    }

    public ColumnName name() {
        return this.name;
    }

    public String toString() {
        return this.toString(FormatOptions.of(word -> false));
    }

    public String toString(FormatOptions formatOptions) {
        return this.qualifier.map(q -> q.toString(formatOptions) + "." + this.name.toString(formatOptions)).orElse(this.name.toString(formatOptions));
    }

    public String aliasedFieldName() {
        if (this.qualifier.isPresent()) {
            return SchemaUtil.buildAliasedFieldName(this.qualifier.get().name(), this.name.name());
        }
        return this.name.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnRef that = (ColumnRef)o;
        return Objects.equals(this.qualifier, that.qualifier) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.qualifier, this.name);
    }

    public ColumnRef withSource(SourceName source) {
        return ColumnRef.of(source, this.name);
    }
}

