/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.ColumnRef;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class Column {
    private final ColumnRef ref;
    private final SqlType type;

    public static Column of(ColumnName name, SqlType type) {
        return new Column(ColumnRef.withoutSource(name), type);
    }

    public static Column of(ColumnRef ref, SqlType type) {
        return new Column(ref, type);
    }

    public static Column of(SourceName source, ColumnName name, SqlType type) {
        return new Column(ColumnRef.of(source, name), type);
    }

    public static Column of(Optional<SourceName> source, ColumnName name, SqlType type) {
        return new Column(ColumnRef.of(source, name), type);
    }

    private Column(ColumnRef ref, SqlType type) {
        this.ref = Objects.requireNonNull(ref, "name");
        this.type = Objects.requireNonNull(type, "type");
    }

    public Optional<SourceName> source() {
        return this.ref.source();
    }

    public ColumnName name() {
        return this.ref.name();
    }

    public SqlType type() {
        return this.type;
    }

    public ColumnRef ref() {
        return this.ref;
    }

    public Column withSource(SourceName source) {
        return new Column(this.ref.withSource(source), this.type);
    }

    public boolean matches(ColumnRef ref) {
        return ref.name().equals(this.ref.name()) && (!this.source().isPresent() || !ref.source().isPresent() || ref.source().equals(this.ref.source()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column that = (Column)o;
        return Objects.equals(this.ref, that.ref) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.ref, this.type);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    public String toString(FormatOptions formatOptions) {
        String fmtType = this.type.toString(formatOptions);
        return this.ref.toString(formatOptions) + " " + fmtType;
    }
}

