/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema;

import io.confluent.ksql.schema.ksql.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.function.BinaryOperator;

public enum Operator {
    ADD("+", SqlDecimal::add){

        @Override
        public SqlType resultType(SqlType left, SqlType right) {
            if (left.baseType() == SqlBaseType.STRING && right.baseType() == SqlBaseType.STRING) {
                return SqlTypes.STRING;
            }
            return super.resultType(left, right);
        }
    }
    ,
    SUBTRACT("-", SqlDecimal::subtract),
    MULTIPLY("*", SqlDecimal::multiply),
    DIVIDE("/", SqlDecimal::divide),
    MODULUS("%", SqlDecimal::modulus);

    private final String symbol;
    private final BinaryOperator<SqlDecimal> binaryResolver;

    private Operator(String symbol, BinaryOperator<SqlDecimal> binaryResolver) {
        this.symbol = Objects.requireNonNull(symbol, "symbol");
        this.binaryResolver = Objects.requireNonNull(binaryResolver, "binaryResolver");
    }

    public String getSymbol() {
        return this.symbol;
    }

    public SqlType resultType(SqlType left, SqlType right) {
        if (left.baseType().isNumber() && right.baseType().isNumber()) {
            if (left.baseType().canImplicitlyCast(right.baseType())) {
                if (right.baseType() != SqlBaseType.DECIMAL) {
                    return right;
                }
                return (SqlType)this.binaryResolver.apply(Operator.toDecimal(left), (SqlDecimal)right);
            }
            if (right.baseType().canImplicitlyCast(left.baseType())) {
                if (left.baseType() != SqlBaseType.DECIMAL) {
                    return left;
                }
                return (SqlType)this.binaryResolver.apply((SqlDecimal)left, Operator.toDecimal(right));
            }
        }
        throw new KsqlException("Unsupported arithmetic types. " + (Object)((Object)left.baseType()) + " " + (Object)((Object)right.baseType()));
    }

    private static SqlDecimal toDecimal(SqlType type) {
        switch (type.baseType()) {
            case DECIMAL: {
                return (SqlDecimal)type;
            }
            case INTEGER: {
                return SqlTypes.INT_UPCAST_TO_DECIMAL;
            }
            case BIGINT: {
                return SqlTypes.BIGINT_UPCAST_TO_DECIMAL;
            }
        }
        throw new KsqlException("Cannot convert " + (Object)((Object)type.baseType()) + " to " + (Object)((Object)SqlBaseType.DECIMAL) + ".");
    }
}

