/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.properties.with;

import io.confluent.ksql.configdef.ConfigValidators;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.parser.DurationParser;
import io.confluent.ksql.properties.with.CommonCreateConfigs;
import io.confluent.ksql.properties.with.ConfigMetaData;
import org.apache.kafka.common.config.ConfigDef;

public final class CreateConfigs {
    public static final String KEY_NAME_PROPERTY = "KEY";
    public static final String WINDOW_TYPE_PROPERTY = "WINDOW_TYPE";
    public static final String WINDOW_SIZE_PROPERTY = "WINDOW_SIZE";
    public static final String AVRO_SCHEMA_ID = "AVRO_SCHEMA_ID";
    public static final String SOURCE_CONNECTOR = "SOURCE_CONNECTOR";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("KEY", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The name of a field within the Kafka record value that matches the key. This may be used by KSQL to avoid unnecessary repartitions.").define("WINDOW_TYPE", ConfigDef.Type.STRING, null, ConfigValidators.enumValues(WindowType.class), ConfigDef.Importance.LOW, "If the data is windowed, i.e. was created using KSQL using a query that contains a ``WINDOW`` clause, then the property can be used to provide the window type. Valid values are SESSION, HOPPING or TUMBLING.").define("WINDOW_SIZE", ConfigDef.Type.STRING, null, ConfigValidators.nullsAllowed(ConfigValidators.parses(DurationParser::parse)), ConfigDef.Importance.LOW, "If the data is windowed, i.e., was created using KSQL via a query that contains a ``WINDOW`` clause and the window is a HOPPING or TUMBLING window, then the property should be used to provide the window size, for example: '20 SECONDS'.").define("AVRO_SCHEMA_ID", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "Undocumented feature").define("SOURCE_CONNECTOR", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "Indicates that this source was created by a connector with the given name. This is useful for understanding which sources map to which connectors and will be automatically populated for connectors.");
    public static final ConfigMetaData CONFIG_METADATA;

    private CreateConfigs() {
    }

    static {
        CommonCreateConfigs.addToConfigDef(CONFIG_DEF, true, true);
        CONFIG_METADATA = ConfigMetaData.of(CONFIG_DEF);
    }
}

