/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.name;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.util.Identifiers;
import java.util.Objects;

@Immutable
public abstract class Name<T extends Name<?>> {
    protected final String name;

    protected Name(String name) {
        this.name = Identifiers.ensureTrimmed(Objects.requireNonNull(name, "name"), "name");
    }

    public String name() {
        return this.name;
    }

    public boolean startsWith(T o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.name.startsWith(((Name)o).name());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name that = (Name)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    public String toString(FormatOptions formatOptions) {
        return formatOptions.escape(this.name);
    }
}

