/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.name;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.Name;

@Immutable
public final class ColumnName
extends Name<ColumnName> {
    private static final String AGGREGATE_COLUMN_PREFIX = "KSQL_AGG_VARIABLE_";
    private static final String GENERATED_ALIAS_PREFIX = "KSQL_COL_";
    private static final String SYNTHESISED_COLUMN_PREFIX = "KSQL_SYNTH_";

    public static ColumnName aggregateColumn(int idx) {
        return ColumnName.of(AGGREGATE_COLUMN_PREFIX + idx);
    }

    public static ColumnName generatedColumnAlias(int idx) {
        return ColumnName.of(GENERATED_ALIAS_PREFIX + idx);
    }

    public static ColumnName synthesisedSchemaColumn(int idx) {
        return ColumnName.of(SYNTHESISED_COLUMN_PREFIX + idx);
    }

    public static ColumnName of(String name) {
        return new ColumnName(name);
    }

    private ColumnName(String name) {
        super(name);
    }

    public boolean isAggregate() {
        return this.name.startsWith(AGGREGATE_COLUMN_PREFIX);
    }
}

