/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import io.confluent.ksql.function.FunctionSignature;
import io.confluent.ksql.function.GenericsUtil;
import io.confluent.ksql.function.UdfSchemaFormatter;
import io.confluent.ksql.schema.connect.SqlSchemaFormatter;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.SchemaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdfIndex<T extends FunctionSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(UdfIndex.class);
    private static final SqlSchemaFormatter FORMATTER = new UdfSchemaFormatter(word -> false, new SqlSchemaFormatter.Option[0]);
    private final String udfName;
    private final Node root = new Node();
    private final Map<List<Schema>, T> allFunctions;

    UdfIndex(String udfName) {
        this.udfName = Objects.requireNonNull(udfName, "udfName");
        this.allFunctions = new HashMap<List<Schema>, T>();
    }

    void addFunction(T function) {
        Node curr;
        List<Schema> parameters = function.getArguments();
        if (this.allFunctions.put(function.getArguments(), function) != null) {
            throw new KsqlException("Can't add function " + function + " as a function with the same name and argument type already exists " + this.allFunctions.get(parameters));
        }
        int order = this.allFunctions.size();
        Node parent = curr = this.root;
        for (Schema parameter : parameters) {
            Parameter param = new Parameter(parameter, false);
            parent = curr;
            curr = curr.children.computeIfAbsent(param, ignored -> new Node());
        }
        if (function.isVariadic()) {
            parent.update(function, order);
            Schema varargSchema = (Schema)Iterables.getLast(function.getArguments());
            Parameter vararg = new Parameter(varargSchema, true);
            Node leaf = parent.children.computeIfAbsent(vararg, ignored -> new Node());
            leaf.update(function, order);
            leaf.children.putIfAbsent(vararg, leaf);
        }
        curr.update(function, order);
    }

    T getFunction(List<Schema> arguments) {
        ArrayList<Node> candidates = new ArrayList<Node>();
        this.getCandidates(arguments, 0, this.root, candidates, new HashMap<Schema, Schema>());
        return (T)candidates.stream().max(Node::compare).map(node -> ((Node)node).value).orElseThrow(() -> this.createNoMatchingFunctionException(arguments));
    }

    private void getCandidates(List<Schema> arguments, int argIndex, Node current, List<Node> candidates, Map<Schema, Schema> reservedGenerics) {
        if (argIndex == arguments.size()) {
            if (current.value != null) {
                candidates.add(current);
            }
            return;
        }
        Schema arg = arguments.get(argIndex);
        for (Map.Entry candidate : current.children.entrySet()) {
            HashMap<Schema, Schema> reservedCopy = new HashMap<Schema, Schema>(reservedGenerics);
            if (!((Parameter)candidate.getKey()).accepts(arg, reservedCopy)) continue;
            Node node = (Node)candidate.getValue();
            this.getCandidates(arguments, argIndex + 1, node, candidates, reservedCopy);
        }
    }

    private KsqlException createNoMatchingFunctionException(List<Schema> paramTypes) {
        LOG.debug("Current UdfIndex:\n{}", (Object)this.describe());
        String sqlParamTypes = paramTypes.stream().map(schema -> schema == null ? null : FORMATTER.format((Schema)schema)).collect(Collectors.joining(", ", "[", "]"));
        return new KsqlException("Function '" + this.udfName + "' does not accept parameters of types:" + sqlParamTypes);
    }

    public Collection<T> values() {
        return this.allFunctions.values();
    }

    private String describe() {
        StringBuilder sb = new StringBuilder();
        sb.append("-ROOT\n");
        this.root.describe(sb, 1);
        return sb.toString();
    }

    static final class Parameter {
        private final Schema schema;
        private final boolean isVararg;

        private Parameter(Schema schema, boolean isVararg) {
            this.isVararg = isVararg;
            this.schema = Objects.requireNonNull(isVararg ? schema.valueSchema() : schema, "schema");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return this.isVararg == parameter.isVararg && Objects.equals(this.schema, parameter.schema);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.isVararg);
        }

        boolean accepts(Schema argument, Map<Schema, Schema> reservedGenerics) {
            if (argument == null) {
                return this.schema.isOptional();
            }
            if (GenericsUtil.hasGenerics(this.schema)) {
                return Parameter.reserveGenerics(this.schema, argument, reservedGenerics);
            }
            return SchemaUtil.areCompatible(this.schema, argument);
        }

        private static boolean reserveGenerics(Schema schema, Schema argument, Map<Schema, Schema> reservedGenerics) {
            if (!GenericsUtil.instanceOf(schema, argument)) {
                return false;
            }
            Map<Schema, Schema> genericMapping = GenericsUtil.resolveGenerics(schema, argument);
            for (Map.Entry<Schema, Schema> entry : genericMapping.entrySet()) {
                Schema old = reservedGenerics.putIfAbsent(entry.getKey(), entry.getValue());
                if (old == null || old.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }

        private static boolean mapEquals(Schema mapA, Schema mapB) {
            return Objects.equals(mapA.keySchema(), mapB.keySchema()) && Objects.equals(mapA.valueSchema(), mapB.valueSchema());
        }

        private static boolean arrayEquals(Schema arrayA, Schema arrayB) {
            return Objects.equals(arrayA.valueSchema(), arrayB.valueSchema());
        }

        private static boolean structEquals(Schema structA, Schema structB) {
            return structA.fields().isEmpty() || structB.fields().isEmpty() || Objects.equals(structA.fields(), structB.fields());
        }

        private static boolean bytesEquals(Schema bytesA, Schema bytesB) {
            return DecimalUtil.isDecimal(bytesA) && DecimalUtil.isDecimal(bytesB);
        }

        public String toString() {
            return FORMATTER.format(this.schema) + (this.isVararg ? "(VARARG)" : "");
        }
    }

    private final class Node {
        @VisibleForTesting
        private final Comparator<T> compareFunctions = Comparator.nullsFirst(Comparator.comparing(fun -> fun.isVariadic() ? 0 : 1).thenComparing(fun -> fun.getArguments().size()));
        private final Map<Parameter, Node> children = new HashMap<Parameter, Node>();
        private T value = null;
        private int order = 0;

        private Node() {
        }

        private void update(T function, int order) {
            if (this.compareFunctions.compare(function, this.value) > 0) {
                this.value = function;
                this.order = order;
            }
        }

        private void describe(StringBuilder builder, int indent) {
            for (Map.Entry<Parameter, Node> child : this.children.entrySet()) {
                if (child.getValue() == this) continue;
                builder.append(StringUtils.repeat((char)' ', (int)(indent * 2))).append('-').append(child.getKey()).append(": ").append(child.getValue()).append('\n');
                child.getValue().describe(builder, indent + 1);
            }
        }

        public String toString() {
            return this.value != null ? this.value.getFunctionName().name() : "EMPTY";
        }

        int compare(Node other) {
            int compare = this.compareFunctions.compare(this.value, other.value);
            return compare == 0 ? -(this.order - other.order) : compare;
        }
    }
}

