/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.KsqlFunction;
import io.confluent.ksql.function.KsqlTableFunction;
import io.confluent.ksql.function.UdfIndex;
import io.confluent.ksql.function.udf.UdfMetadata;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;

public class TableFunctionFactory {
    private final UdfIndex<KsqlTableFunction> udtfIndex;
    private final UdfMetadata metadata;

    public TableFunctionFactory(UdfMetadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata");
        this.udtfIndex = new UdfIndex(metadata.getName());
    }

    public UdfMetadata getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.metadata.getName();
    }

    public synchronized void eachFunction(Consumer<KsqlTableFunction> consumer) {
        this.udtfIndex.values().forEach(consumer);
    }

    public synchronized KsqlTableFunction createTableFunction(List<Schema> argTypeList) {
        return this.udtfIndex.getFunction(argTypeList);
    }

    protected synchronized List<List<Schema>> supportedArgs() {
        return this.udtfIndex.values().stream().map(KsqlFunction::getArguments).collect(Collectors.toList());
    }

    synchronized void addFunction(KsqlTableFunction tableFunction) {
        this.udtfIndex.addFunction(tableFunction);
    }
}

