/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.KsqlFunction;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.connect.data.Schema;

@Immutable
public final class KsqlScalarFunction
extends KsqlFunction {
    static final String INTERNAL_PATH = "internal";
    private final Class<? extends Kudf> kudfClass;
    private final Function<KsqlConfig, Kudf> udfFactory;

    private KsqlScalarFunction(Function<List<Schema>, Schema> returnSchemaProvider, Schema javaReturnType, List<Schema> arguments, FunctionName functionName, Class<? extends Kudf> kudfClass, Function<KsqlConfig, Kudf> udfFactory, String description, String pathLoadedFrom, boolean isVariadic) {
        super(returnSchemaProvider, javaReturnType, arguments, functionName, description, pathLoadedFrom, isVariadic);
        this.kudfClass = Objects.requireNonNull(kudfClass, "kudfClass");
        this.udfFactory = Objects.requireNonNull(udfFactory, "udfFactory");
    }

    public static KsqlScalarFunction createLegacyBuiltIn(Schema returnType, List<Schema> arguments, FunctionName functionName, Class<? extends Kudf> kudfClass) {
        Function<KsqlConfig, Kudf> udfFactory = ksqlConfig -> {
            try {
                return (Kudf)kudfClass.newInstance();
            }
            catch (Exception e) {
                throw new KsqlException("Failed to create instance of kudfClass " + kudfClass + " for function " + functionName, e);
            }
        };
        return KsqlScalarFunction.create(ignored -> returnType, returnType, arguments, functionName, kudfClass, udfFactory, "", INTERNAL_PATH, false);
    }

    public Class<? extends Kudf> getKudfClass() {
        return this.kudfClass;
    }

    static KsqlScalarFunction create(Function<List<Schema>, Schema> schemaProvider, Schema javaReturnType, List<Schema> arguments, FunctionName functionName, Class<? extends Kudf> kudfClass, Function<KsqlConfig, Kudf> udfFactory, String description, String pathLoadedFrom, boolean isVariadic) {
        return new KsqlScalarFunction(schemaProvider, javaReturnType, arguments, functionName, kudfClass, udfFactory, description, pathLoadedFrom, isVariadic);
    }

    @Override
    public String toString() {
        return "KsqlFunction{, kudfClass=" + this.kudfClass + '}';
    }

    public Kudf newInstance(KsqlConfig ksqlConfig) {
        return this.udfFactory.apply(ksqlConfig);
    }
}

