/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.confluent.ksql.function.FunctionSignature;
import io.confluent.ksql.function.GenericsUtil;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.FormatOptions;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.SchemaUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

@Immutable
public class KsqlFunction
implements FunctionSignature {
    private final Function<List<Schema>, Schema> returnSchemaProvider;
    private final Schema javaReturnType;
    private final List<Schema> parameters;
    private final FunctionName functionName;
    private final String description;
    private final String pathLoadedFrom;
    private final boolean isVariadic;

    KsqlFunction(Function<List<Schema>, Schema> returnSchemaProvider, Schema javaReturnType, List<Schema> arguments, FunctionName functionName, String description, String pathLoadedFrom, boolean isVariadic) {
        this.returnSchemaProvider = Objects.requireNonNull(returnSchemaProvider, "schemaProvider");
        this.javaReturnType = Objects.requireNonNull(javaReturnType, "javaReturnType");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments"));
        this.functionName = Objects.requireNonNull(functionName, "functionName");
        this.description = Objects.requireNonNull(description, "description");
        this.pathLoadedFrom = Objects.requireNonNull(pathLoadedFrom, "pathLoadedFrom");
        this.isVariadic = isVariadic;
        if (arguments.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("KSQL Function can't have null argument types");
        }
        if (isVariadic) {
            if (arguments.isEmpty()) {
                throw new IllegalArgumentException("KSQL variadic functions must have at least one parameter");
            }
            if (!((Schema)Iterables.getLast(arguments)).type().equals((Object)Schema.Type.ARRAY)) {
                throw new IllegalArgumentException("KSQL variadic functions must have ARRAY type as their last parameter");
            }
        }
    }

    public Schema getReturnType(List<Schema> arguments) {
        Schema returnType = this.returnSchemaProvider.apply(arguments);
        if (returnType == null) {
            throw new KsqlException(String.format("Return type of UDF %s cannot be null.", this.functionName));
        }
        if (!returnType.isOptional()) {
            throw new IllegalArgumentException("KSQL only supports optional field types");
        }
        if (!GenericsUtil.hasGenerics(returnType)) {
            this.checkMatchingReturnTypes(returnType, this.javaReturnType);
            return returnType;
        }
        HashMap<Schema, Schema> genericMapping = new HashMap<Schema, Schema>();
        for (int i = 0; i < Math.min(this.parameters.size(), arguments.size()); ++i) {
            Schema schema = this.parameters.get(i);
            Schema instance = this.isVariadic && i == this.parameters.size() - 1 ? SchemaBuilder.array((Schema)arguments.get(i)).build() : arguments.get(i);
            genericMapping.putAll(GenericsUtil.resolveGenerics(schema, instance));
        }
        Schema genericSchema = GenericsUtil.applyResolved(returnType, genericMapping);
        Schema genericJavaSchema = GenericsUtil.applyResolved(this.javaReturnType, genericMapping);
        this.checkMatchingReturnTypes(genericSchema, genericJavaSchema);
        return genericSchema;
    }

    private void checkMatchingReturnTypes(Schema s1, Schema s2) {
        if (!SchemaUtil.areCompatible(s1, s2)) {
            throw new KsqlException(String.format("Return type %s of UDF %s does not match the declared return type %s.", SchemaConverters.connectToSqlConverter().toSqlType(s1).toString(), this.functionName.toString(FormatOptions.noEscape()), SchemaConverters.connectToSqlConverter().toSqlType(s2).toString()));
        }
    }

    @Override
    public List<Schema> getArguments() {
        return this.parameters;
    }

    @Override
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPathLoadedFrom() {
        return this.pathLoadedFrom;
    }

    @Override
    public boolean isVariadic() {
        return this.isVariadic;
    }

    public String toString() {
        return "KsqlFunction{returnType=" + this.javaReturnType + ", arguments=" + this.parameters.stream().map(Schema::type).collect(Collectors.toList()) + ", functionName='" + this.functionName + '\'' + ", description='" + this.description + "', pathLoadedFrom='" + this.pathLoadedFrom + "', isVariadic=" + this.isVariadic + '}';
    }
}

