/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlPreconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public final class GenericsUtil {
    private static final String PREFIX = "<";
    private static final String SUFFIX = ">";
    private static final Pattern GENERIC_PATTERN = Pattern.compile("<(?<name>.*)>");

    private GenericsUtil() {
    }

    public static SchemaBuilder generic(String typeName) {
        return SchemaBuilder.bytes().optional().name(PREFIX + typeName + SUFFIX);
    }

    public static SchemaBuilder array(String typeName) {
        return SchemaBuilder.array((Schema)GenericsUtil.generic(typeName).build()).optional();
    }

    public static SchemaBuilder map(Schema keyType, String valueTypeName) {
        return SchemaBuilder.map((Schema)keyType, (Schema)GenericsUtil.generic(valueTypeName).build()).optional();
    }

    public static boolean isGeneric(Schema type) {
        return type.name() != null && type.name().startsWith(PREFIX) && type.name().endsWith(SUFFIX);
    }

    public static Set<Schema> constituentGenerics(Schema type) {
        switch (type.type()) {
            case ARRAY: {
                return GenericsUtil.constituentGenerics(type.valueSchema());
            }
            case MAP: {
                return Sets.union(GenericsUtil.constituentGenerics(type.keySchema()), GenericsUtil.constituentGenerics(type.valueSchema()));
            }
            case STRUCT: {
                return type.fields().stream().map(Field::schema).map(GenericsUtil::constituentGenerics).flatMap(Collection::stream).collect(Collectors.toSet());
            }
            case BYTES: {
                if (GenericsUtil.isGeneric(type)) {
                    return ImmutableSet.of((Object)type);
                }
                return ImmutableSet.of();
            }
        }
        return ImmutableSet.of();
    }

    public static boolean hasGenerics(Schema type) {
        return !GenericsUtil.constituentGenerics(type).isEmpty();
    }

    public static Schema applyResolved(Schema schema, Map<Schema, Schema> resolved) {
        switch (schema.type()) {
            case ARRAY: {
                return SchemaBuilder.array((Schema)GenericsUtil.applyResolved(schema.valueSchema(), resolved)).optional().build();
            }
            case MAP: {
                return SchemaBuilder.map((Schema)GenericsUtil.applyResolved(schema.keySchema(), resolved), (Schema)GenericsUtil.applyResolved(schema.valueSchema(), resolved)).optional().build();
            }
            case BYTES: {
                if (!GenericsUtil.isGeneric(schema)) {
                    return schema;
                }
                Schema instance = resolved.get(schema);
                if (instance == null) {
                    throw new KsqlException("Could not find mapping for generic type: " + schema);
                }
                return instance;
            }
        }
        return schema;
    }

    public static Map<Schema, Schema> resolveGenerics(Schema schema, Schema instance) {
        ArrayList<Map.Entry<Schema, Schema>> genericMapping = new ArrayList<Map.Entry<Schema, Schema>>();
        boolean success = GenericsUtil.resolveGenerics(genericMapping, schema, instance);
        if (!success) {
            throw new KsqlException(String.format("Cannot infer generics for %s from %s because they do not have the same schema structure.", schema, instance));
        }
        HashMap mapping = new HashMap();
        for (Map.Entry entry : genericMapping) {
            Schema old = (Schema)mapping.putIfAbsent(entry.getKey(), entry.getValue());
            if (old == null || old.equals(entry.getValue())) continue;
            throw new KsqlException(String.format("Found invalid instance of generic schema. Cannot map %s to both %s and %s", schema.name(), old, instance));
        }
        return ImmutableMap.copyOf(mapping);
    }

    private static boolean resolveGenerics(List<Map.Entry<Schema, Schema>> mapping, Schema schema, Schema instance) {
        if (!GenericsUtil.isGeneric(schema) && instance.type() != schema.type()) {
            return false;
        }
        if (!GenericsUtil.hasGenerics(schema)) {
            return true;
        }
        KsqlPreconditions.checkArgument(GenericsUtil.isGeneric(schema) || instance.type() == schema.type(), "Cannot resolve generics if the schema and instance have differing types: " + schema + " vs. " + instance);
        switch (schema.type()) {
            case BYTES: {
                mapping.add(new AbstractMap.SimpleEntry<Schema, Schema>(schema, instance));
                return true;
            }
            case ARRAY: {
                return GenericsUtil.resolveGenerics(mapping, schema.valueSchema(), instance.valueSchema());
            }
            case MAP: {
                return GenericsUtil.resolveGenerics(mapping, schema.keySchema(), instance.keySchema()) && GenericsUtil.resolveGenerics(mapping, schema.valueSchema(), instance.valueSchema());
            }
            case STRUCT: {
                throw new KsqlException("Generic STRUCT is not yet supported");
            }
        }
        return true;
    }

    public static boolean instanceOf(Schema schema, Schema instance) {
        ArrayList<Map.Entry<Schema, Schema>> mappings = new ArrayList<Map.Entry<Schema, Schema>>();
        if (!GenericsUtil.resolveGenerics(mappings, schema, instance)) {
            return false;
        }
        HashMap asMap = new HashMap();
        for (Map.Entry entry : mappings) {
            Schema old = (Schema)asMap.putIfAbsent(entry.getKey(), entry.getValue());
            if (old == null || old.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static String name(Schema schema) {
        Matcher matcher = GENERIC_PATTERN.matcher(schema.name());
        if (matcher.matches()) {
            return matcher.group("name");
        }
        throw new KsqlException("Cannot extract name from non-generic schema: " + schema);
    }
}

