/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.function.AggregateFunctionInitArguments;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.function.udf.UdfMetadata;
import io.confluent.ksql.util.DecimalUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.Schema;

public abstract class AggregateFunctionFactory {
    private final UdfMetadata metadata;
    protected static final List<List<Schema>> NUMERICAL_ARGS = ImmutableList.builder().add((Object)ImmutableList.of((Object)Schema.OPTIONAL_INT32_SCHEMA)).add((Object)ImmutableList.of((Object)Schema.OPTIONAL_INT64_SCHEMA)).add((Object)ImmutableList.of((Object)Schema.OPTIONAL_FLOAT64_SCHEMA)).add((Object)ImmutableList.of((Object)DecimalUtil.builder(1, 1).build())).build();

    public AggregateFunctionFactory(String functionName) {
        this(new UdfMetadata(functionName, "", "Confluent", "", "internal", false));
    }

    public AggregateFunctionFactory(UdfMetadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata can't be null");
    }

    public abstract KsqlAggregateFunction<?, ?, ?> createAggregateFunction(List<Schema> var1, AggregateFunctionInitArguments var2);

    protected abstract List<List<Schema>> supportedArgs();

    public UdfMetadata getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.metadata.getName();
    }

    public void eachFunction(Consumer<KsqlAggregateFunction<?, ?, ?>> consumer) {
        this.supportedArgs().forEach(args -> consumer.accept(this.createAggregateFunction((List<Schema>)args, this.getDefaultArguments())));
    }

    public AggregateFunctionInitArguments getDefaultArguments() {
        return AggregateFunctionInitArguments.EMPTY_ARGS;
    }
}

