/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.configdef;

import java.net.URL;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public final class ConfigValidators {
    private ConfigValidators() {
    }

    public static ConfigDef.Validator parses(Function<String, ?> parser) {
        return (name, val) -> {
            if (val != null && !(val instanceof String)) {
                throw new IllegalArgumentException("validator should only be used with STRING defs");
            }
            try {
                parser.apply((String)val);
            }
            catch (Exception e) {
                throw new ConfigException("Configuration " + name + " is invalid: " + e.getMessage());
            }
        };
    }

    public static ConfigDef.Validator nullsAllowed(ConfigDef.Validator delegate) {
        return (name, value) -> {
            if (value == null) {
                return;
            }
            delegate.ensureValid(name, value);
        };
    }

    public static <T extends Enum<T>> ConfigDef.Validator enumValues(Class<T> enumClass) {
        String[] enumValues = (String[])EnumSet.allOf(enumClass).stream().map(Object::toString).toArray(String[]::new);
        String[] validValues = Arrays.copyOf(enumValues, enumValues.length + 1);
        validValues[enumValues.length] = null;
        return ValidCaseInsensitiveString.in(validValues);
    }

    public static ConfigDef.Validator validUrl() {
        return (name, val) -> {
            if (!(val instanceof String)) {
                throw new IllegalArgumentException("validator should only be used with STRING defs");
            }
            try {
                new URL((String)val);
            }
            catch (Exception e) {
                throw new ConfigException(name, val, "Not valid URL: " + e.getMessage());
            }
        };
    }

    public static final class ValidCaseInsensitiveString
    implements ConfigDef.Validator {
        private final List<String> validStrings;

        private ValidCaseInsensitiveString(String ... validStrings) {
            this.validStrings = Arrays.stream((Object[])Objects.requireNonNull(validStrings, "validStrings")).map(v -> v == null ? null : v.toUpperCase()).collect(Collectors.toList());
        }

        public static ValidCaseInsensitiveString in(String ... validStrings) {
            return new ValidCaseInsensitiveString(validStrings);
        }

        public void ensureValid(String name, Object value) {
            String s = (String)value;
            if (!this.validStrings.contains(s == null ? null : s.toUpperCase())) {
                throw new ConfigException(name, value, "String must be one of: " + String.join((CharSequence)", ", this.validStrings));
            }
        }

        public String toString() {
            return "[" + String.join((CharSequence)", ", this.validStrings) + "]";
        }
    }
}

