/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.json;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaJsonSchemaSerde<T>
implements Serde<T> {
    private Class<T> specificClass;
    private final Serde<T> inner;

    public KafkaJsonSchemaSerde() {
        this.inner = Serdes.serdeFrom((Serializer)new KafkaJsonSchemaSerializer(), (Deserializer)new KafkaJsonSchemaDeserializer());
    }

    public KafkaJsonSchemaSerde(Class<T> specificClass) {
        this.specificClass = specificClass;
        this.inner = Serdes.serdeFrom((Serializer)new KafkaJsonSchemaSerializer(), (Deserializer)new KafkaJsonSchemaDeserializer());
    }

    public KafkaJsonSchemaSerde(SchemaRegistryClient client) {
        this(client, null);
    }

    public KafkaJsonSchemaSerde(SchemaRegistryClient client, Class<T> specificClass) {
        if (client == null) {
            throw new IllegalArgumentException("schema registry client must not be null");
        }
        this.specificClass = specificClass;
        this.inner = Serdes.serdeFrom((Serializer)new KafkaJsonSchemaSerializer(client), (Deserializer)new KafkaJsonSchemaDeserializer(client));
    }

    public Serializer<T> serializer() {
        return this.inner.serializer();
    }

    public Deserializer<T> deserializer() {
        return this.inner.deserializer();
    }

    public void configure(Map<String, ?> serdeConfig, boolean isSerdeForRecordKeys) {
        this.inner.serializer().configure(serdeConfig, isSerdeForRecordKeys);
        this.inner.deserializer().configure(this.withSpecificClass(serdeConfig, isSerdeForRecordKeys), isSerdeForRecordKeys);
    }

    public void close() {
        this.inner.serializer().close();
        this.inner.deserializer().close();
    }

    private Map<String, Object> withSpecificClass(Map<String, ?> config, boolean isKey) {
        HashMap<String, Object> newConfig;
        if (this.specificClass == null) {
            return config;
        }
        HashMap<String, Object> hashMap = newConfig = config == null ? new HashMap<String, Object>() : new HashMap<String, Object>(config);
        if (isKey) {
            newConfig.put("json.key.type", this.specificClass);
        } else {
            newConfig.put("json.value.type", this.specificClass);
        }
        return newConfig;
    }
}

