/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.wrapper;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.schema.id.DualSchemaIdDeserializer;
import io.confluent.kafka.serializers.schema.id.SchemaId;
import io.confluent.kafka.serializers.schema.id.SchemaIdDeserializer;
import io.confluent.kafka.serializers.wrapper.CompositeDeserializerConfig;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDeserializer
implements Deserializer<Object> {
    protected Logger log = LoggerFactory.getLogger(CompositeDeserializer.class);
    private boolean isKey;
    private SchemaIdDeserializer schemaIdDeserializer;
    private Deserializer<?> oldDeserializer;
    private Deserializer<?> confluentDeserializer;
    private SchemaRegistryClient schemaRegistryClient;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new CompositeDeserializerConfig(configs), isKey);
    }

    protected void configure(CompositeDeserializerConfig config, boolean isKey) {
        this.isKey = isKey;
        Map originals = config.originals();
        this.schemaIdDeserializer = new DualSchemaIdDeserializer();
        this.oldDeserializer = (Deserializer)config.getConfiguredInstance("composite.old.deserializer", Deserializer.class);
        this.oldDeserializer.configure(originals, isKey);
        this.confluentDeserializer = (Deserializer)config.getConfiguredInstance("composite.confluent.deserializer", Deserializer.class);
        this.confluentDeserializer.configure(originals, isKey);
        this.schemaRegistryClient = this.getSchemaRegistryClient();
    }

    public Object deserialize(String topic, byte[] bytes) {
        return this.deserialize(topic, null, bytes);
    }

    public Object deserialize(String topic, Headers headers, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        SchemaId schemaId = new SchemaId("");
        try {
            this.schemaIdDeserializer.deserialize(topic, this.isKey, headers, bytes, schemaId);
            if (this.isValidSchemaId(topic, schemaId)) {
                return this.confluentDeserializer.deserialize(topic, headers, bytes);
            }
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        return this.oldDeserializer.deserialize(topic, bytes);
    }

    private boolean isValidSchemaId(String topic, SchemaId schemaId) {
        return schemaId.getGuid() != null || this.hasValidId(topic, schemaId.getId());
    }

    private boolean hasValidId(String topic, Integer id) {
        if (id == null || id <= 0) {
            return false;
        }
        String subject = this.isKey ? topic + "-key" : topic + "-value";
        try {
            ParsedSchema schema = this.schemaRegistryClient.getSchemaBySubjectAndId(subject, id.intValue());
            int savedId = this.schemaRegistryClient.getId(subject, schema);
            return id == savedId;
        }
        catch (Exception e) {
            this.log.warn("Error while validating schema id", (Throwable)e);
            return false;
        }
    }

    private SchemaRegistryClient getSchemaRegistryClient() {
        if (!(this.confluentDeserializer instanceof AbstractKafkaSchemaSerDe)) {
            throw new IllegalArgumentException("Value of 'confluent.deserializer' property must be an instance of 'io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe'");
        }
        return ((AbstractKafkaSchemaSerDe)this.confluentDeserializer).getSchemaRegistryClient();
    }

    public void close() {
        this.oldDeserializer.close();
        this.confluentDeserializer.close();
    }
}

