/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppInfoParser {
    private static final Logger log = LoggerFactory.getLogger(AppInfoParser.class);

    public static String getCommitId() {
        return AppInfoParser.readAppProperty("application.commitId", "Unknown");
    }

    public static String getVersion() {
        return AppInfoParser.readAppProperty("application.version", "Unknown");
    }

    private static String readAppProperty(String propertyName, String defaultValue) {
        String fileName = "/schema-registry-app.properties";
        String propertyValue = defaultValue;
        try (InputStream propFile = AppInfoParser.class.getResourceAsStream(fileName);){
            if (propFile != null) {
                Properties props = new Properties();
                props.load(propFile);
                propertyValue = props.getProperty(propertyName, defaultValue).trim();
            } else {
                log.error("Cannot find properties file");
            }
        }
        catch (IOException e) {
            log.warn("Cannot parse properties file", (Throwable)e);
        }
        return propertyValue;
    }
}

