/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.kafka.schemaregistry.storage.RuleKind;
import io.confluent.kafka.schemaregistry.storage.RuleMode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Rule {
    private final String name;
    private final String doc;
    private final RuleKind kind;
    private final RuleMode mode;
    private final String type;
    private final SortedSet<String> tags;
    @JsonPropertyOrder(alphabetic=true)
    private final SortedMap<String, String> params;
    private final String expr;
    private final String onSuccess;
    private final String onFailure;
    private final boolean disabled;

    @JsonCreator
    public Rule(@JsonProperty(value="name") String name, @JsonProperty(value="doc") String doc, @JsonProperty(value="kind") RuleKind kind, @JsonProperty(value="mode") RuleMode mode, @JsonProperty(value="type") String type, @JsonProperty(value="tags") SortedSet<String> tags, @JsonProperty(value="params") SortedMap<String, String> params, @JsonProperty(value="expr") String expr, @JsonProperty(value="onSuccess") String onSuccess, @JsonProperty(value="onFailure") String onFailure, @JsonProperty(value="disabled") boolean disabled) {
        this.name = name;
        this.doc = doc;
        this.kind = kind;
        this.mode = mode;
        this.type = type;
        this.tags = tags != null ? Collections.unmodifiableSortedSet(tags) : null;
        this.params = params != null ? Collections.unmodifiableSortedMap(params) : null;
        this.expr = expr;
        this.onSuccess = onSuccess;
        this.onFailure = onFailure;
        this.disabled = disabled;
    }

    public Rule(io.confluent.kafka.schemaregistry.client.rest.entities.Rule rule) {
        this.name = rule.getName();
        this.doc = rule.getDoc();
        this.kind = RuleKind.fromEntity(rule.getKind());
        this.mode = RuleMode.fromEntity(rule.getMode());
        this.type = rule.getType();
        this.tags = Collections.unmodifiableSortedSet(rule.getTags());
        this.params = Collections.unmodifiableSortedMap(rule.getParams());
        this.expr = rule.getExpr();
        this.onSuccess = rule.getOnSuccess();
        this.onFailure = rule.getOnFailure();
        this.disabled = rule.isDisabled();
    }

    @Schema(description="Rule name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Schema(description="Rule doc")
    @JsonProperty(value="doc")
    public String getDoc() {
        return this.doc;
    }

    @Schema(description="Rule kind")
    @JsonProperty(value="kind")
    public RuleKind getKind() {
        return this.kind;
    }

    @Schema(description="Rule mode")
    @JsonProperty(value="mode")
    public RuleMode getMode() {
        return this.mode;
    }

    @Schema(description="Rule type")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Schema(description="The tags to which this rule applies")
    @JsonProperty(value="tags")
    public SortedSet<String> getTags() {
        return this.tags;
    }

    @Schema(description="The optional params for the rule")
    @JsonProperty(value="params")
    public SortedMap<String, String> getParams() {
        return this.params;
    }

    @Schema(description="Rule expression")
    @JsonProperty(value="expr")
    public String getExpr() {
        return this.expr;
    }

    @Schema(description="Rule action on success")
    @JsonProperty(value="onSuccess")
    public String getOnSuccess() {
        return this.onSuccess;
    }

    @Schema(description="Rule action on failure")
    @JsonProperty(value="onFailure")
    public String getOnFailure() {
        return this.onFailure;
    }

    @Schema(description="Whether the rule is disabled")
    @JsonProperty(value="disabled")
    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.name, rule.name) && Objects.equals(this.doc, rule.doc) && this.kind == rule.kind && this.mode == rule.mode && Objects.equals(this.type, rule.type) && Objects.equals(this.tags, rule.tags) && Objects.equals(this.params, rule.params) && Objects.equals(this.expr, rule.expr) && Objects.equals(this.onSuccess, rule.onSuccess) && Objects.equals(this.onFailure, rule.onFailure) && this.disabled == rule.disabled;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.doc, this.kind, this.mode, this.type, this.tags, this.params, this.expr, this.onSuccess, this.onFailure, this.disabled});
    }

    public String toString() {
        return "Rule{name=" + this.name + ", doc=" + this.doc + ", kind=" + (Object)((Object)this.kind) + ", mode=" + (Object)((Object)this.mode) + ", type='" + this.type + '\'' + ", tags='" + this.tags + '\'' + ", params='" + this.params + '\'' + ", expr='" + this.expr + '\'' + ", onSuccess='" + this.onSuccess + '\'' + ", onFailure='" + this.onFailure + '\'' + ", disabled='" + this.disabled + '\'' + '}';
    }

    public io.confluent.kafka.schemaregistry.client.rest.entities.Rule toRuleEntity() {
        return new io.confluent.kafka.schemaregistry.client.rest.entities.Rule(this.getName(), this.getDoc(), this.getKind().toEntity(), this.getMode().toEntity(), this.getType(), this.getTags(), this.getParams(), this.getExpr(), this.getOnSuccess(), this.getOnFailure(), this.isDisabled());
    }
}

