/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.leaderelector.kafka;

import java.util.Map;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

class ClientConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG = new ConfigDef().define("client.dns.lookup", ConfigDef.Type.STRING, (Object)ClientDnsLookup.USE_ALL_DNS_IPS.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()}), ConfigDef.Importance.MEDIUM, "Controls how the client uses DNS lookups. If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established. After a disconnection, the next IP is used. Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however). If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names. After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.").define("metadata.max.age.ms", ConfigDef.Type.LONG, (Object)300000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.").define("send.buffer.bytes", ConfigDef.Type.INT, (Object)131072, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-1), ConfigDef.Importance.MEDIUM, "The size of the TCP send buffer (SO_SNDBUF) to use when sending data. If the value is -1, the OS default will be used.").define("receive.buffer.bytes", ConfigDef.Type.INT, (Object)65536, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-1), ConfigDef.Importance.MEDIUM, "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data. If the value is -1, the OS default will be used.").define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)50L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>reconnect.backoff.max.ms</code> value.").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)1000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.").define("retry.backoff.ms", ConfigDef.Type.LONG, (Object)100L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios. This value is the initial backoff value and will increase exponentially for each failed request, up to the <code>retry.backoff.max.ms</code> value.").define("retry.backoff.max.ms", ConfigDef.Type.LONG, (Object)1000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when retrying a request to the broker that has repeatedly failed. If provided, the backoff per client will increase exponentially for each failed request, up to this maximum. To prevent all clients from being synchronized upon retry, a randomized jitter with a factor of 0.2 will be applied to the backoff, resulting in the backoff falling within a range between 20% below and 20% above the computed value. If <code>retry.backoff.ms</code> is set to be higher than <code>retry.backoff.max.ms</code>, then <code>retry.backoff.max.ms</code> will be used as a constant backoff from the beginning without any exponential increase").define("request.timeout.ms", ConfigDef.Type.INT, (Object)305000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").define("connections.max.idle.ms", ConfigDef.Type.LONG, (Object)540000L, ConfigDef.Importance.MEDIUM, "Close idle connections after the number of milliseconds specified by this config.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).withClientSslSupport().withClientSaslSupport();
    public static final long METADATA_MAX_AGE_DEFAULT = 300000L;
    public static final int SEND_BUFFER_DEFAULT = 131072;
    public static final int RECEIVE_BUFFER_DEFAULT = 65536;
    public static final long RECONNECT_BACKOFF_MS_DEFAULT = 50L;
    public static final long RECONNECT_BACKOFF_MAX_MS_DEFAULT = 1000L;
    public static final long RETRY_BACKOFF_MS_DEFAULT = 100L;
    public static final long RETRY_BACKOFF_MAX_MS_DEFAULT = 1000L;
    public static final int REQUEST_TIMEOUT_MS_DEFAULT = 305000;
    public static final long CONNECTIONS_MAX_IDLE_MS_DEFAULT = 540000L;

    ClientConfig(Map<String, ?> props) {
        super(CONFIG, props);
    }

    ClientConfig(Map<String, ?> props, boolean doLog) {
        super(CONFIG, props, doLog);
    }
}

