/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.OauthTokenCache;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.exceptions.SchemaRegistryOauthTokenRetrieverException;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.JwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;

public class CachedOauthTokenRetriever {
    private JwtRetriever tokenRetriever;
    private JwtValidator tokenValidator;
    private OauthTokenCache oauthTokenCache;

    public void configure(JwtRetriever tokenRetriever, JwtValidator tokenValidator, OauthTokenCache oauthTokenCache) {
        this.tokenRetriever = tokenRetriever;
        this.tokenValidator = tokenValidator;
        this.oauthTokenCache = oauthTokenCache;
    }

    public String getToken() {
        if (this.oauthTokenCache.isTokenExpired()) {
            OAuthBearerToken oauthBearerToken;
            String token = null;
            try {
                token = this.tokenRetriever.retrieve();
            }
            catch (JwtRetrieverException e) {
                throw new SchemaRegistryOauthTokenRetrieverException("Failed to Retrieve OAuth Token for Schema Registry", e);
            }
            try {
                oauthBearerToken = this.tokenValidator.validate(token);
            }
            catch (JwtValidatorException e) {
                throw new SchemaRegistryOauthTokenRetrieverException("OAuth Token for Schema Registry is Invalid", e);
            }
            this.oauthTokenCache.setCurrentToken(oauthBearerToken);
        }
        return this.oauthTokenCache.getCurrentToken().value();
    }
}

