/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.utils;

import com.google.common.base.CharMatcher;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.IllegalPropertyException;

public class RestValidation {
    public static final int NAME_MAX_LENGTH = 256;

    public static void checkName(String name, String propertyName) {
        if (name == null || name.isEmpty()) {
            throw new IllegalPropertyException(propertyName, "cannot be null or empty");
        }
        if (name.length() > 256) {
            throw new IllegalPropertyException(propertyName, "exceeds max length of 256");
        }
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            throw new IllegalPropertyException(propertyName, "must start with a letter or underscore");
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-') continue;
            throw new IllegalPropertyException(propertyName, "illegal character '" + c + "'");
        }
    }

    public static void checkSubject(String subject) {
        if (subject == null || subject.isEmpty() || CharMatcher.javaIsoControl().matchesAnyOf((CharSequence)subject)) {
            throw new IllegalPropertyException("subject", "must not be empty");
        }
    }
}

