/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.rest.entities.LifecyclePolicy;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.AssociationCreateOrUpdateInfo;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.IllegalPropertyException;
import io.confluent.kafka.schemaregistry.client.rest.utils.RestValidation;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssociationCreateOrUpdateRequest {
    private static final String DEFAULT_RESOURCE_TYPE = "topic";
    private static final String DEFAULT_ASSOCIATION_TYPE = "value";
    private static final LifecyclePolicy DEFAULT_LIFECYCLE = LifecyclePolicy.STRONG;
    private String resourceName;
    private String resourceNamespace;
    private String resourceId;
    private String resourceType;
    private List<AssociationCreateOrUpdateInfo> associations;

    @JsonCreator
    public AssociationCreateOrUpdateRequest(@JsonProperty(value="resourceName") String resourceName, @JsonProperty(value="resourceNamespace") String resourceNamespace, @JsonProperty(value="resourceId") String resourceId, @JsonProperty(value="resourceType") String resourceType, @JsonProperty(value="associations") List<AssociationCreateOrUpdateInfo> associations) {
        this.resourceName = resourceName;
        this.resourceNamespace = resourceNamespace;
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.associations = associations;
    }

    @JsonProperty(value="resourceName")
    public String getResourceName() {
        return this.resourceName;
    }

    @JsonProperty(value="resourceName")
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @JsonProperty(value="resourceNamespace")
    public String getResourceNamespace() {
        return this.resourceNamespace;
    }

    @JsonProperty(value="resourceNamespace")
    public void setResourceNamespace(String resourceNamespace) {
        this.resourceNamespace = resourceNamespace;
    }

    @JsonProperty(value="resourceId")
    public String getResourceId() {
        return this.resourceId;
    }

    @JsonProperty(value="resourceId")
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @JsonProperty(value="resourceType")
    public String getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @JsonProperty(value="associations")
    public List<AssociationCreateOrUpdateInfo> getAssociations() {
        return this.associations;
    }

    @JsonProperty(value="associations")
    public void setAssociations(List<AssociationCreateOrUpdateInfo> associations) {
        this.associations = associations;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationCreateOrUpdateRequest that = (AssociationCreateOrUpdateRequest)o;
        return Objects.equals(this.resourceName, that.resourceName) && Objects.equals(this.resourceNamespace, that.resourceNamespace) && Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.associations, that.associations);
    }

    public int hashCode() {
        return Objects.hash(this.resourceName, this.resourceNamespace, this.resourceId, this.resourceType, this.associations);
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }

    public void validate() {
        RestValidation.checkName(this.getResourceName(), "resourceName");
        RestValidation.checkName(this.getResourceNamespace(), "resourceNamespace");
        if (this.getResourceId() == null || this.getResourceId().isEmpty()) {
            throw new IllegalPropertyException("resourceId", "cannot be null or empty");
        }
        if (this.getResourceType() != null && !this.getResourceType().isEmpty()) {
            RestValidation.checkName(this.getResourceType(), "resourceType");
        } else {
            this.setResourceType(DEFAULT_RESOURCE_TYPE);
        }
        for (AssociationCreateOrUpdateInfo info : this.getAssociations()) {
            RestValidation.checkSubject(info.getSubject());
            if (info.getAssociationType() != null && !info.getAssociationType().isEmpty()) {
                RestValidation.checkName(info.getAssociationType(), "associationType");
            } else {
                info.setAssociationType(DEFAULT_ASSOCIATION_TYPE);
            }
            if (info.getLifecycle() != LifecyclePolicy.WEAK || !Boolean.TRUE.equals(info.getFrozen())) continue;
            throw new IllegalPropertyException("frozen", "association with lifecycle of WEAK cannot be frozen");
        }
    }
}

