/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientConfig;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryDeployment;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryServerVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.security.SslFactory;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSchemaRegistryClient
implements SchemaRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(CachedSchemaRegistryClient.class);
    private final RestService restService;
    private final int cacheCapacity;
    private final Cache<String, Cache<ParsedSchema, RegisterSchemaResponse>> schemaToResponseCache;
    private final Cache<String, Cache<ParsedSchema, Integer>> schemaToIdCache;
    private final Cache<String, Cache<Integer, ParsedSchema>> idToSchemaCache;
    private final Cache<String, ParsedSchema> guidToSchemaCache;
    private final Cache<String, Cache<ParsedSchema, String>> schemaToGuidCache;
    private final Cache<String, Cache<ParsedSchema, Integer>> schemaToVersionCache;
    private final Cache<String, Cache<Integer, Schema>> versionToSchemaCache;
    private final Cache<String, SchemaMetadata> latestVersionCache;
    private final Cache<SubjectAndMetadata, SchemaMetadata> latestWithMetadataCache;
    private final Cache<SubjectAndSchema, Long> missingSchemaCache;
    private final Cache<SubjectAndInt, Long> missingIdCache;
    private final Cache<String, Long> missingGuidCache;
    private final Cache<SubjectAndInt, Long> missingVersionCache;
    private final LoadingCache<Schema, ParsedSchema> parsedSchemaCache;
    private final Map<String, SchemaProvider> providers;
    private final Ticker ticker;
    private static final String NO_SUBJECT = "";
    private static final int HTTP_NOT_FOUND = 404;
    private static final int VERSION_NOT_FOUND_ERROR_CODE = 40402;
    private static final int SCHEMA_NOT_FOUND_ERROR_CODE = 40403;
    private static final int SUBJECT_NOT_FOUND_ERROR_CODE = 40401;
    public static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = RestService.DEFAULT_REQUEST_PROPERTIES;

    public CachedSchemaRegistryClient(String baseUrl, int cacheCapacity) {
        this(new RestService(baseUrl), cacheCapacity);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity) {
        this(new RestService(baseUrls), cacheCapacity);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity) {
        this(restService, cacheCapacity, null);
    }

    public CachedSchemaRegistryClient(String baseUrl, int cacheCapacity, Map<String, ?> originals) {
        this(baseUrl, cacheCapacity, originals, null);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, Map<String, ?> originals) {
        this(baseUrls, cacheCapacity, originals, null);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> originals) {
        this(new RestService(baseUrls), cacheCapacity, providers, originals, null);
    }

    public CachedSchemaRegistryClient(String baseUrls, int identityMapCapacity, List<SchemaProvider> providers, Map<String, ?> originals) {
        this(new RestService(baseUrls), identityMapCapacity, providers, originals, null);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, Map<String, ?> configs) {
        this(restService, cacheCapacity, null, configs, null);
    }

    public CachedSchemaRegistryClient(String baseUrl, int cacheCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrl), cacheCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), cacheCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), cacheCapacity, providers, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(String baseUrls, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), cacheCapacity, providers, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(restService, cacheCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> configs, Map<String, String> httpHeaders) {
        this(restService, cacheCapacity, providers, configs, httpHeaders, Ticker.systemTicker());
    }

    public CachedSchemaRegistryClient(RestService restService, int cacheCapacity, List<SchemaProvider> providers, Map<String, ?> configs, Map<String, String> httpHeaders, Ticker ticker) {
        this.cacheCapacity = cacheCapacity;
        this.schemaToResponseCache = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).build();
        this.schemaToIdCache = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).build();
        this.idToSchemaCache = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).build();
        this.schemaToGuidCache = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).build();
        this.guidToSchemaCache = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).build();
        this.schemaToVersionCache = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).build();
        this.versionToSchemaCache = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).build();
        this.restService = restService;
        this.ticker = ticker;
        long latestTTL = SchemaRegistryClientConfig.getLatestTTL(configs);
        CacheBuilder latestVersionBuilder = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).ticker(ticker);
        if (latestTTL >= 0L) {
            latestVersionBuilder = latestVersionBuilder.expireAfterWrite(latestTTL, TimeUnit.SECONDS);
        }
        this.latestVersionCache = latestVersionBuilder.build();
        CacheBuilder latestWithMetadataBuilder = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).ticker(ticker);
        if (latestTTL >= 0L) {
            latestWithMetadataBuilder = latestWithMetadataBuilder.expireAfterWrite(latestTTL, TimeUnit.SECONDS);
        }
        this.latestWithMetadataCache = latestWithMetadataBuilder.build();
        int maxMissingCacheSize = SchemaRegistryClientConfig.getMaxMissingCacheSize(configs);
        long missingSchemaTTL = SchemaRegistryClientConfig.getMissingSchemaTTL(configs);
        this.missingSchemaCache = CacheBuilder.newBuilder().maximumSize((long)maxMissingCacheSize).ticker(ticker).expireAfterWrite(missingSchemaTTL, TimeUnit.SECONDS).build();
        long missingIdTTL = SchemaRegistryClientConfig.getMissingIdTTL(configs);
        this.missingIdCache = CacheBuilder.newBuilder().maximumSize((long)maxMissingCacheSize).ticker(ticker).expireAfterWrite(missingIdTTL, TimeUnit.SECONDS).build();
        this.missingGuidCache = CacheBuilder.newBuilder().maximumSize((long)maxMissingCacheSize).ticker(ticker).expireAfterWrite(missingIdTTL, TimeUnit.SECONDS).build();
        long missingVersionTTL = SchemaRegistryClientConfig.getMissingVersionTTL(configs);
        this.missingVersionCache = CacheBuilder.newBuilder().maximumSize((long)maxMissingCacheSize).ticker(ticker).expireAfterWrite(missingVersionTTL, TimeUnit.SECONDS).build();
        this.providers = providers != null && !providers.isEmpty() ? providers.stream().collect(Collectors.toMap(SchemaProvider::schemaType, p -> p)) : Collections.singletonMap("AVRO", new AvroSchemaProvider());
        HashMap<String, CachedSchemaRegistryClient> schemaProviderConfigs = new HashMap<String, CachedSchemaRegistryClient>();
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        for (SchemaProvider provider : this.providers.values()) {
            provider.configure(schemaProviderConfigs);
        }
        final Map<String, SchemaProvider> schemaProviders = this.providers;
        this.parsedSchemaCache = CacheBuilder.newBuilder().maximumSize((long)cacheCapacity).build((CacheLoader)new CacheLoader<Schema, ParsedSchema>(){

            public ParsedSchema load(Schema schema) throws Exception {
                SchemaProvider schemaProvider;
                String schemaType = schema.getSchemaType();
                if (schemaType == null) {
                    schemaType = "AVRO";
                }
                if ((schemaProvider = (SchemaProvider)schemaProviders.get(schemaType)) == null) {
                    log.error("Invalid schema type {}", (Object)schemaType);
                    throw new IllegalStateException("Invalid schema type " + schemaType);
                }
                return schemaProvider.parseSchemaOrElseThrow(schema, false, false);
            }
        });
        if (httpHeaders != null) {
            restService.setHttpHeaders(httpHeaders);
        }
        if (configs != null && !configs.isEmpty()) {
            Map<String, Object> restConfigs = configs.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("schema.registry.") ? ((String)e.getKey()).substring("schema.registry.".length()) : (String)e.getKey(), Map.Entry::getValue, (existing, replacement) -> replacement));
            restService.configure(restConfigs);
            Map<String, Object> sslConfigs = configs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("schema.registry.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("schema.registry.".length()), Map.Entry::getValue));
            SslFactory sslFactory = new SslFactory(sslConfigs);
            if (sslFactory.sslContext() != null) {
                restService.setSslSocketFactory(sslFactory.sslContext().getSocketFactory());
                restService.setHostnameVerifier(this.getHostnameVerifier(sslConfigs));
            }
        }
    }

    @Override
    public Ticker ticker() {
        return this.ticker;
    }

    private HostnameVerifier getHostnameVerifier(Map<String, Object> config) {
        String sslEndpointIdentificationAlgo = (String)config.get("ssl.endpoint.identification.algorithm");
        if (sslEndpointIdentificationAlgo == null || sslEndpointIdentificationAlgo.equals("none") || sslEndpointIdentificationAlgo.isEmpty()) {
            return (hostname, session) -> true;
        }
        return null;
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        return this.parseSchema(new Schema(null, null, null, schemaType, references, schemaString));
    }

    @Override
    public Optional<ParsedSchema> parseSchema(Schema schema) {
        try {
            return Optional.of((ParsedSchema)this.parsedSchemaCache.get((Object)schema));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }

    @Override
    public ParsedSchema parseSchemaOrElseThrow(Schema schema) throws IOException {
        try {
            return (ParsedSchema)this.parsedSchemaCache.get((Object)schema);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw new IOException(cause);
            }
            throw new IOException(e);
        }
    }

    public Map<String, SchemaProvider> getSchemaProviders() {
        return this.providers;
    }

    private RegisterSchemaResponse registerAndGetId(String subject, ParsedSchema schema, boolean normalize, boolean propagateSchemaTags) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        if (propagateSchemaTags) {
            request.setPropagateSchemaTags(true);
        }
        return this.restService.registerSchema(request, subject, normalize);
    }

    private RegisterSchemaResponse registerAndGetId(String subject, ParsedSchema schema, int version, int id, boolean normalize, boolean propagateSchemaTags) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        request.setVersion(version);
        request.setId(id);
        if (propagateSchemaTags) {
            request.setPropagateSchemaTags(true);
        }
        return this.restService.registerSchema(request, subject, normalize);
    }

    protected ParsedSchema getSchemaByIdFromRegistry(int id, String subject) throws IOException, RestClientException {
        SchemaString restSchema;
        if (this.missingIdCache.getIfPresent((Object)new SubjectAndInt(subject, id)) != null) {
            throw new RestClientException("Schema " + id + " not found", 404, 40403);
        }
        try {
            restSchema = this.restService.getId(id, subject);
        }
        catch (RestClientException rce) {
            if (this.isSchemaOrSubjectNotFoundException(rce)) {
                this.missingIdCache.put((Object)new SubjectAndInt(subject, id), (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        return this.parseSchemaOrElseThrow(new Schema(null, null, null, restSchema));
    }

    protected ParsedSchema getSchemaByGuidFromRegistry(String guid, String format) throws IOException, RestClientException {
        SchemaString restSchema;
        String cacheKey;
        String string = cacheKey = format != null ? guid + ":" + format : guid;
        if (this.missingGuidCache.getIfPresent((Object)cacheKey) != null) {
            throw new RestClientException("Schema " + guid + " not found", 404, 40403);
        }
        try {
            restSchema = this.restService.getByGuid(guid, format);
        }
        catch (RestClientException rce) {
            if (this.isSchemaOrSubjectNotFoundException(rce)) {
                this.missingGuidCache.put((Object)cacheKey, (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        Optional<ParsedSchema> schema = this.parseSchema(new Schema(null, null, null, restSchema));
        return schema.orElseThrow(() -> new IOException("Invalid schema of type " + restSchema.getSchemaType()));
    }

    private int getVersionFromRegistry(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.getIdWithResponseFromRegistry(subject, schema, normalize, true).getVersion();
    }

    private int getIdFromRegistry(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.getIdWithResponseFromRegistry(subject, schema, normalize, false).getId();
    }

    private String getGuidFromRegistry(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.getIdWithResponseFromRegistry(subject, schema, normalize, false).getGuid();
    }

    private RegisterSchemaResponse getIdWithResponseFromRegistry(String subject, ParsedSchema schema, boolean normalize, boolean lookupDeletedSchema) throws IOException, RestClientException {
        RegisterSchemaResponse response;
        this.checkMissingSchemaCache(subject, schema, normalize);
        try {
            RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
            Schema schemaEntity = this.restService.lookUpSubjectVersion(request, subject, normalize, lookupDeletedSchema);
            response = new RegisterSchemaResponse(schemaEntity);
        }
        catch (RestClientException rce) {
            if (this.isSchemaOrSubjectNotFoundException(rce)) {
                this.missingSchemaCache.put((Object)new SubjectAndSchema(subject, schema, normalize), (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        return response;
    }

    @Override
    public int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1);
    }

    @Override
    public int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, 0, -1, normalize, false).getId();
    }

    @Override
    public int register(String subject, ParsedSchema schema, int version, int id) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, version, id, false, false).getId();
    }

    @Override
    public RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, boolean normalize, boolean propagateSchemaTags) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, 0, -1, normalize, propagateSchemaTags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, int version, int id, boolean normalize, boolean propagateSchemaTags) throws IOException, RestClientException {
        try {
            Cache schemaResponseMap = (Cache)this.schemaToResponseCache.get((Object)subject, () -> CacheBuilder.newBuilder().maximumSize((long)this.cacheCapacity).build());
            RegisterSchemaResponse cachedResponse = (RegisterSchemaResponse)schemaResponseMap.getIfPresent((Object)schema);
            if (cachedResponse != null && (id < 0 || id == cachedResponse.getId())) {
                return cachedResponse;
            }
            CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
            synchronized (cachedSchemaRegistryClient) {
                cachedResponse = (RegisterSchemaResponse)schemaResponseMap.getIfPresent((Object)schema);
                if (cachedResponse != null && (id < 0 || id == cachedResponse.getId())) {
                    return cachedResponse;
                }
                RegisterSchemaResponse retrievedResponse = id >= 0 ? this.registerAndGetId(subject, schema, version, id, normalize, propagateSchemaTags) : this.registerAndGetId(subject, schema, normalize, propagateSchemaTags);
                schemaResponseMap.put((Object)schema, (Object)retrievedResponse);
                String context = CachedSchemaRegistryClient.toQualifiedContext(subject);
                Cache idSchemaMap = (Cache)this.idToSchemaCache.get((Object)context, () -> CacheBuilder.newBuilder().maximumSize((long)this.cacheCapacity).build());
                idSchemaMap.put((Object)retrievedResponse.getId(), (Object)schema);
                return retrievedResponse;
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error accessing cache", e);
        }
    }

    @Override
    public ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.getSchemaBySubjectAndId(NO_SUBJECT, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        if (subject == null) {
            subject = NO_SUBJECT;
        }
        try {
            Cache idSchemaMap = (Cache)this.idToSchemaCache.get((Object)subject, () -> CacheBuilder.newBuilder().maximumSize((long)this.cacheCapacity).build());
            ParsedSchema cachedSchema = (ParsedSchema)idSchemaMap.getIfPresent((Object)id);
            if (cachedSchema != null) {
                return cachedSchema;
            }
            CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
            synchronized (cachedSchemaRegistryClient) {
                cachedSchema = (ParsedSchema)idSchemaMap.getIfPresent((Object)id);
                if (cachedSchema != null) {
                    return cachedSchema;
                }
                ParsedSchema retrievedSchema = this.getSchemaByIdFromRegistry(id, subject);
                idSchemaMap.put((Object)id, (Object)retrievedSchema);
                return retrievedSchema;
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error accessing cache", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParsedSchema getSchemaByGuid(String guid, String format) throws IOException, RestClientException {
        Object cacheKey = format != null ? guid + ":" + format : guid;
        ParsedSchema cachedSchema = (ParsedSchema)this.guidToSchemaCache.getIfPresent(cacheKey);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
        synchronized (cachedSchemaRegistryClient) {
            cachedSchema = (ParsedSchema)this.guidToSchemaCache.getIfPresent(cacheKey);
            if (cachedSchema != null) {
                return cachedSchema;
            }
            ParsedSchema retrievedSchema = this.getSchemaByGuidFromRegistry(guid, format);
            this.guidToSchemaCache.put(cacheKey, (Object)retrievedSchema);
            return retrievedSchema;
        }
    }

    @Override
    public List<ParsedSchema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        List<Schema> restSchemas = this.restService.getSchemas(subjectPrefix, lookupDeletedSchema, latestOnly);
        return restSchemas.stream().map(this::parseSchema).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        return this.restService.getAllSubjectsById(id);
    }

    @Override
    public Collection<SubjectVersion> getAllVersionsById(int id) throws IOException, RestClientException {
        return this.restService.getAllVersionsById(id);
    }

    @Override
    public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        try {
            return this.getSchemaByVersion(subject, version, lookupDeletedSchema);
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema getSchemaByVersion(String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        try {
            Schema cachedSchema;
            Cache versionSchemaMap = (Cache)this.versionToSchemaCache.get((Object)subject, () -> CacheBuilder.newBuilder().maximumSize((long)this.cacheCapacity).build());
            Schema schema = cachedSchema = lookupDeletedSchema ? (Schema)versionSchemaMap.getIfPresent((Object)version) : null;
            if (cachedSchema != null) {
                return cachedSchema;
            }
            CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
            synchronized (cachedSchemaRegistryClient) {
                Schema schema2 = cachedSchema = lookupDeletedSchema ? (Schema)versionSchemaMap.getIfPresent((Object)version) : null;
                if (cachedSchema != null) {
                    return cachedSchema;
                }
                Schema retrievedSchema = this.getSchemaByVersionFromRegistry(subject, version, lookupDeletedSchema);
                if (lookupDeletedSchema) {
                    versionSchemaMap.put((Object)version, (Object)retrievedSchema);
                }
                return retrievedSchema;
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error accessing cache", e);
        }
    }

    private Schema getSchemaByVersionFromRegistry(String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        Schema restSchema;
        if (lookupDeletedSchema && this.missingVersionCache.getIfPresent((Object)new SubjectAndInt(subject, version)) != null) {
            throw new RestClientException("Version " + version + " not found", 404, 40402);
        }
        try {
            restSchema = this.restService.getVersion(subject, version, lookupDeletedSchema);
        }
        catch (RestClientException rce) {
            if (lookupDeletedSchema && this.isVersionNotFoundException(rce)) {
                this.missingVersionCache.put((Object)new SubjectAndInt(subject, version), (Object)System.currentTimeMillis());
            }
            throw rce;
        }
        return restSchema;
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        return this.getSchemaMetadata(subject, version, false);
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        Schema response = this.getSchemaByVersion(subject, version, lookupDeletedSchema);
        return new SchemaMetadata(response);
    }

    @Override
    public SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        SchemaMetadata schema = (SchemaMetadata)this.latestVersionCache.getIfPresent((Object)subject);
        if (schema != null) {
            return schema;
        }
        Schema response = this.restService.getLatestVersion(subject);
        schema = new SchemaMetadata(response);
        this.latestVersionCache.put((Object)subject, (Object)schema);
        return schema;
    }

    @Override
    public SchemaMetadata getLatestWithMetadata(String subject, Map<String, String> metadata, boolean lookupDeletedSchema) throws IOException, RestClientException {
        SubjectAndMetadata subjectAndMetadata = new SubjectAndMetadata(subject, metadata);
        SchemaMetadata schema = (SchemaMetadata)this.latestWithMetadataCache.getIfPresent((Object)subjectAndMetadata);
        if (schema != null) {
            return schema;
        }
        Schema response = this.restService.getLatestWithMetadata(subject, metadata, lookupDeletedSchema);
        schema = new SchemaMetadata(response);
        this.latestWithMetadataCache.put((Object)subjectAndMetadata, (Object)schema);
        return schema;
    }

    @Override
    public int getVersion(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getVersion(subject, schema, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVersion(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        try {
            Cache schemaVersionMap = (Cache)this.schemaToVersionCache.get((Object)subject, () -> CacheBuilder.newBuilder().maximumSize((long)this.cacheCapacity).build());
            Integer cachedVersion = (Integer)schemaVersionMap.getIfPresent((Object)schema);
            if (cachedVersion != null) {
                return cachedVersion;
            }
            CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
            synchronized (cachedSchemaRegistryClient) {
                cachedVersion = (Integer)schemaVersionMap.getIfPresent((Object)schema);
                if (cachedVersion != null) {
                    return cachedVersion;
                }
                int retrievedVersion = this.getVersionFromRegistry(subject, schema, normalize);
                schemaVersionMap.put((Object)schema, (Object)retrievedVersion);
                return retrievedVersion;
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error accessing cache", e);
        }
    }

    @Override
    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        return this.restService.getAllVersions(subject);
    }

    @Override
    public List<Integer> getAllVersions(String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        return this.restService.getAllVersions(RestService.DEFAULT_REQUEST_PROPERTIES, subject, lookupDeletedSchema);
    }

    @Override
    public int getId(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getId(subject, schema, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        try {
            Cache schemaIdMap = (Cache)this.schemaToIdCache.get((Object)subject, () -> CacheBuilder.newBuilder().maximumSize((long)this.cacheCapacity).build());
            Integer cachedId = (Integer)schemaIdMap.getIfPresent((Object)schema);
            if (cachedId != null) {
                return cachedId;
            }
            CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
            synchronized (cachedSchemaRegistryClient) {
                cachedId = (Integer)schemaIdMap.getIfPresent((Object)schema);
                if (cachedId != null) {
                    return cachedId;
                }
                int retrievedId = this.getIdFromRegistry(subject, schema, normalize);
                schemaIdMap.put((Object)schema, (Object)retrievedId);
                String context = CachedSchemaRegistryClient.toQualifiedContext(subject);
                Cache idSchemaMap = (Cache)this.idToSchemaCache.get((Object)context, () -> CacheBuilder.newBuilder().maximumSize((long)this.cacheCapacity).build());
                idSchemaMap.put((Object)retrievedId, (Object)schema);
                return retrievedId;
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error accessing cache", e);
        }
    }

    @Override
    public String getGuid(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getGuid(subject, schema, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGuid(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        try {
            Cache guidMap = (Cache)this.schemaToGuidCache.get((Object)subject, () -> CacheBuilder.newBuilder().maximumSize((long)this.cacheCapacity).build());
            String cachedGuid = (String)guidMap.getIfPresent((Object)schema);
            if (cachedGuid != null) {
                return cachedGuid;
            }
            CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
            synchronized (cachedSchemaRegistryClient) {
                cachedGuid = (String)guidMap.getIfPresent((Object)schema);
                if (cachedGuid != null) {
                    return cachedGuid;
                }
                String retrievedGuid = this.getGuidFromRegistry(subject, schema, normalize);
                guidMap.put((Object)schema, (Object)retrievedGuid);
                this.guidToSchemaCache.put((Object)retrievedGuid, (Object)schema);
                return retrievedGuid;
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error accessing cache", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterSchemaResponse getIdWithResponse(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        try {
            Cache schemaResponseMap = (Cache)this.schemaToResponseCache.get((Object)subject, () -> CacheBuilder.newBuilder().maximumSize((long)this.cacheCapacity).build());
            RegisterSchemaResponse cachedResponse = (RegisterSchemaResponse)schemaResponseMap.getIfPresent((Object)schema);
            if (cachedResponse != null && cachedResponse.getVersion() != null && cachedResponse.getVersion() > 0) {
                return cachedResponse;
            }
            CachedSchemaRegistryClient cachedSchemaRegistryClient = this;
            synchronized (cachedSchemaRegistryClient) {
                cachedResponse = (RegisterSchemaResponse)schemaResponseMap.getIfPresent((Object)schema);
                if (cachedResponse != null && cachedResponse.getVersion() != null && cachedResponse.getVersion() > 0) {
                    return cachedResponse;
                }
                RegisterSchemaResponse retrievedResponse = this.getIdWithResponseFromRegistry(subject, schema, normalize, false);
                schemaResponseMap.put((Object)schema, (Object)retrievedResponse);
                String context = CachedSchemaRegistryClient.toQualifiedContext(subject);
                Cache idSchemaMap = (Cache)this.idToSchemaCache.get((Object)context, () -> CacheBuilder.newBuilder().maximumSize((long)this.cacheCapacity).build());
                idSchemaMap.put((Object)retrievedResponse.getId(), (Object)schema);
                return retrievedResponse;
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error accessing cache", e);
        }
    }

    @Override
    public List<Integer> deleteSubject(String subject, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSubject(DEFAULT_REQUEST_PROPERTIES, subject, isPermanent);
    }

    @Override
    public synchronized List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        Objects.requireNonNull(subject, "subject");
        this.schemaToVersionCache.invalidate((Object)subject);
        if (isPermanent) {
            this.versionToSchemaCache.invalidate((Object)subject);
        }
        this.idToSchemaCache.invalidate((Object)subject);
        this.schemaToIdCache.invalidate((Object)subject);
        this.schemaToResponseCache.invalidate((Object)subject);
        this.latestVersionCache.invalidate((Object)subject);
        this.latestWithMetadataCache.invalidateAll();
        return this.restService.deleteSubject(requestProperties, subject, isPermanent);
    }

    @Override
    public Integer deleteSchemaVersion(String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSchemaVersion(DEFAULT_REQUEST_PROPERTIES, subject, version, isPermanent);
    }

    @Override
    public synchronized Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        Cache schemaCache;
        Cache versionCache = (Cache)this.schemaToVersionCache.getIfPresent((Object)subject);
        if (versionCache != null) {
            versionCache.asMap().values().remove(Integer.valueOf(version));
        }
        if (isPermanent && (schemaCache = (Cache)this.versionToSchemaCache.getIfPresent((Object)subject)) != null) {
            schemaCache.invalidate((Object)Integer.valueOf(version));
        }
        this.latestVersionCache.invalidate((Object)subject);
        this.latestWithMetadataCache.invalidateAll();
        return this.restService.deleteSchemaVersion(requestProperties, subject, version, isPermanent);
    }

    @Override
    public boolean testCompatibility(String subject, ParsedSchema schema) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        return this.restService.testCompatibility(request, subject, "latest", false, false).isEmpty();
    }

    @Override
    public List<String> testCompatibilityVerbose(String subject, ParsedSchema schema) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        return this.restService.testCompatibility(request, subject, "latest", false, true);
    }

    @Override
    public List<String> testCompatibilityVerbose(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        return this.restService.testCompatibility(request, subject, "latest", normalize, true);
    }

    @Override
    public Config updateConfig(String subject, Config config) throws IOException, RestClientException {
        ConfigUpdateRequest response = this.restService.updateConfig(new ConfigUpdateRequest(config), subject);
        return new Config(response);
    }

    @Override
    public Config getConfig(String subject) throws IOException, RestClientException {
        return this.restService.getConfig(subject);
    }

    @Override
    public void deleteConfig(String subject) throws IOException, RestClientException {
        this.restService.deleteConfig(subject);
    }

    @Override
    public String setMode(String mode) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode);
        return response.getMode();
    }

    @Override
    public String setMode(String mode, String subject) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode, subject);
        return response.getMode();
    }

    @Override
    public String setMode(String mode, String subject, boolean force) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode, subject, force);
        return response.getMode();
    }

    @Override
    public String getMode() throws IOException, RestClientException {
        Mode response = this.restService.getMode();
        return response.getMode();
    }

    @Override
    public String getMode(String subject) throws IOException, RestClientException {
        Mode response = this.restService.getMode(subject);
        return response.getMode();
    }

    @Override
    public void deleteMode(String subject) throws IOException, RestClientException {
        this.restService.deleteSubjectMode(subject);
    }

    @Override
    public Collection<String> getAllContexts() throws IOException, RestClientException {
        return this.restService.getAllContexts();
    }

    @Override
    public SchemaRegistryDeployment getSchemaRegistryDeployment() throws IOException, RestClientException {
        return this.restService.getSchemaRegistryDeployment();
    }

    @Override
    public SchemaRegistryServerVersion getSchemaRegistryServerVersion() throws IOException, RestClientException {
        return this.restService.getSchemaRegistryServerVersion();
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        return this.restService.getAllSubjects();
    }

    @Override
    public Collection<String> getAllSubjects(boolean lookupDeletedSubject) throws IOException, RestClientException {
        return this.restService.getAllSubjects(lookupDeletedSubject);
    }

    @Override
    public Collection<String> getAllSubjectsByPrefix(String subjectPrefix) throws IOException, RestClientException {
        return this.restService.getAllSubjects(subjectPrefix, false);
    }

    @Override
    public synchronized void reset() {
        this.schemaToResponseCache.invalidateAll();
        this.schemaToIdCache.invalidateAll();
        this.idToSchemaCache.invalidateAll();
        this.schemaToVersionCache.invalidateAll();
        this.versionToSchemaCache.invalidateAll();
        this.schemaToGuidCache.invalidateAll();
        this.guidToSchemaCache.invalidateAll();
        this.latestVersionCache.invalidateAll();
        this.latestWithMetadataCache.invalidateAll();
        this.missingSchemaCache.invalidateAll();
        this.missingIdCache.invalidateAll();
        this.missingGuidCache.invalidateAll();
        this.missingVersionCache.invalidateAll();
    }

    @Override
    public void close() throws IOException {
        if (this.restService != null) {
            this.restService.close();
        }
    }

    private void checkMissingSchemaCache(String subject, ParsedSchema schema, boolean normalize) throws RestClientException {
        if (this.missingSchemaCache.getIfPresent((Object)new SubjectAndSchema(subject, schema, normalize)) != null) {
            throw new RestClientException("Schema not found", 404, 40403);
        }
    }

    private boolean isVersionNotFoundException(RestClientException rce) {
        return rce.getStatus() == 404 && rce.getErrorCode() == 40402;
    }

    private boolean isSchemaOrSubjectNotFoundException(RestClientException rce) {
        return rce.getStatus() == 404 && (rce.getErrorCode() == 40403 || rce.getErrorCode() == 40401);
    }

    private static String toQualifiedContext(String subject) {
        QualifiedSubject qualifiedSubject = QualifiedSubject.create("default", subject);
        return qualifiedSubject != null ? qualifiedSubject.toQualifiedContext() : NO_SUBJECT;
    }

    static class SubjectAndInt {
        private final String subject;
        private final int id;

        public SubjectAndInt(String subject, int id) {
            this.subject = subject;
            this.id = id;
        }

        public String subject() {
            return this.subject;
        }

        public int id() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectAndInt that = (SubjectAndInt)o;
            return Objects.equals(this.subject, that.subject) && this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.id);
        }

        public String toString() {
            return "SubjectAndId{subject='" + this.subject + "', id=" + this.id + "}";
        }
    }

    static class SubjectAndSchema {
        private final String subject;
        private final ParsedSchema schema;
        private final boolean normalize;

        public SubjectAndSchema(String subject, ParsedSchema schema, boolean normalize) {
            this.subject = subject;
            this.schema = schema;
            this.normalize = normalize;
        }

        public String subject() {
            return this.subject;
        }

        public ParsedSchema schema() {
            return this.schema;
        }

        public boolean normalize() {
            return this.normalize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectAndSchema that = (SubjectAndSchema)o;
            return Objects.equals(this.subject, that.subject) && this.schema.equals(that.schema) && this.normalize == that.normalize;
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.schema, this.normalize);
        }

        public String toString() {
            return "SubjectAndSchema{subject='" + this.subject + "', schema=" + String.valueOf(this.schema) + ", normalize=" + this.normalize + "}";
        }
    }

    static class SubjectAndMetadata {
        private final String subject;
        private final Map<String, String> metadata;

        public SubjectAndMetadata(String subject, Map<String, String> metadata) {
            this.subject = subject;
            this.metadata = ImmutableMap.copyOf(metadata);
        }

        public String subject() {
            return this.subject;
        }

        public Map<String, String> metadata() {
            return this.metadata;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectAndMetadata that = (SubjectAndMetadata)o;
            return Objects.equals(this.subject, that.subject) && Objects.equals(this.metadata, that.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.metadata);
        }

        public String toString() {
            return "SubjectAndMetadata{subject='" + this.subject + "', metadata=" + String.valueOf(this.metadata) + "}";
        }
    }
}

