/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.local;

import com.google.crypto.tink.KmsClient;
import io.confluent.kafka.schemaregistry.encryption.local.LocalKmsClient;
import io.confluent.kafka.schemaregistry.encryption.tink.KmsDriver;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Optional;

public class LocalKmsDriver
implements KmsDriver {
    public static final String SECRET = "secret";
    public static final String LOCAL_SECRET = "LOCAL_SECRET";

    public String getKeyUrlPrefix() {
        return "local-kms://";
    }

    private String getSecret(Map<String, ?> configs) throws GeneralSecurityException {
        String secret = (String)configs.get(SECRET);
        if (secret == null) {
            secret = System.getenv(LOCAL_SECRET);
        }
        if (secret == null) {
            throw new GeneralSecurityException("cannot load secret");
        }
        return secret;
    }

    public KmsClient newKmsClient(Map<String, ?> configs, Optional<String> kekUrl) throws GeneralSecurityException {
        return new LocalKmsClient(kekUrl.orElse("local-kms://"), this.getSecret(configs));
    }
}

