/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.response;

import com.fasterxml.jackson.databind.MappingIterator;
import com.google.common.base.Suppliers;
import io.confluent.kafkarest.exceptions.ProduceRequestTooLargeException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public final class JsonStream<T>
implements Closeable {
    private final Supplier<MappingIterator<T>> delegate = Suppliers.memoize(delegate::get);
    private final SizeLimitEntityStream inputStream;

    public JsonStream(Supplier<MappingIterator<T>> delegate) {
        this(delegate, null);
    }

    public JsonStream(Supplier<MappingIterator<T>> delegate, SizeLimitEntityStream inputStream) {
        this.inputStream = inputStream;
    }

    public boolean hasNext() {
        if (this.delegate.get() == null) {
            return false;
        }
        return this.delegate.get().hasNext();
    }

    public T nextValue() throws IOException {
        if (this.delegate.get() == null) {
            throw new NoSuchElementException();
        }
        Object value = this.delegate.get().nextValue();
        if (this.inputStream != null) {
            this.inputStream.resetCounter();
        }
        return (T)value;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.invalidateCounter();
        }
        if (this.delegate.get() != null) {
            this.delegate.get().close();
        }
    }

    public static class SizeLimitEntityStream
    extends InputStream {
        private final InputStream delegate;
        private final long sizeThreshold;
        private final AtomicLong produceRequestByteCounter = new AtomicLong(0L);

        public SizeLimitEntityStream(InputStream delegate, long sizeThreshold) {
            this.delegate = delegate;
            this.sizeThreshold = sizeThreshold;
        }

        @Override
        public int read() throws IOException {
            int v = this.delegate.read();
            if (v != -1) {
                this.validateSize(1L);
            }
            return v;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int v = this.delegate.read(b);
            if (v != -1) {
                this.validateSize(v);
            }
            return v;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int v = this.delegate.read(b, off, len);
            if (v != -1) {
                this.validateSize(v);
            }
            return v;
        }

        @Override
        public long skip(long n) throws IOException {
            long v = this.delegate.skip(n);
            this.validateSize(v);
            return v;
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        private void resetCounter() {
            this.produceRequestByteCounter.set(0L);
        }

        private void invalidateCounter() {
            this.produceRequestByteCounter.set(Long.MIN_VALUE);
        }

        private void validateSize(long add) {
            if (this.produceRequestByteCounter.addAndGet(add) > this.sizeThreshold) {
                throw new ProduceRequestTooLargeException();
            }
        }
    }
}

