/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.response;

import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.response.CrnFactory;
import jakarta.inject.Inject;
import java.util.StringJoiner;

public final class CrnFactoryImpl
implements CrnFactory {
    private static final char SEPARATOR = '/';
    private final String baseCrn;

    @Inject
    public CrnFactoryImpl(@ConfigModule.CrnAuthorityConfig String crnAuthorityConfig) {
        this.baseCrn = CrnFactoryImpl.computeBaseCrn(crnAuthorityConfig);
    }

    @Override
    public String create(String ... components) {
        if (components.length % 2 != 0) {
            throw new IllegalArgumentException("Expected an even number of components on the form: type1, id1, type2, id2, etc.");
        }
        StringJoiner joiner = new StringJoiner(String.valueOf('/')).add(this.baseCrn);
        for (int i = 0; i < components.length; i += 2) {
            if (components[i + 1] != null) {
                joiner.add(String.format("%s=%s", CrnFactoryImpl.trimSeparator(components[i]), CrnFactoryImpl.trimSeparator(components[i + 1])));
                continue;
            }
            joiner.add(String.format("%s", CrnFactoryImpl.trimSeparator(components[i])));
        }
        return joiner.toString();
    }

    private static String computeBaseCrn(String crnAuthorityConfig) {
        return String.format("crn://%s", CrnFactoryImpl.trimSeparator(crnAuthorityConfig));
    }

    private static String trimSeparator(String component) {
        int end;
        int beginning;
        for (beginning = 0; beginning < component.length() && component.charAt(beginning) == '/'; ++beginning) {
        }
        for (end = component.length() - 1; end >= 0 && component.charAt(end) == '/'; --end) {
        }
        return beginning <= end ? component.substring(beginning, end + 1) : "";
    }
}

