/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafkarest.KafkaRestConfig;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.utils.Time;

final class ProducerMetrics {
    private static final String GROUP_NAME = "produce-api-metrics";
    public static final long EXPIRY_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    private static final String REQUEST_SENSOR_NAME = "request-sensor";
    private static final String REQUEST_SIZE_SENSOR_NAME = "request-size-sensor";
    private static final String RESPONSE_SENSOR_NAME = "response-sensor";
    private static final String RECORD_ERROR_SENSOR_NAME = "record-error-sensor";
    private static final String RECORD_RATE_LIMITED_SENSOR_NAME = "record-rate-limited-sensor";
    private static final String REQUEST_LATENCY_SENSOR_NAME = "request-latency-sensor";
    static final String REQUEST_RATE_METRIC_NAME = "request-rate";
    private static final String REQUEST_RATE_METRIC_DOC = "The average number of requests sent per second.";
    static final String REQUEST_COUNT_WINDOWED_METRIC_NAME = "request-count-windowed";
    private static final String REQUEST_COUNT_WINDOWED_METRIC_DOC = "The total number of requests sent within the given window.";
    static final String RESPONSE_RATE_METRIC_NAME = "response-rate";
    private static final String RESPONSE_RATE_METRIC_DOC = "The average number of responses sent per second.";
    static final String RESPONSE_COUNT_WINDOWED_METRIC_NAME = "response-count-windowed";
    private static final String RESPONSE_COUNT_WINDOWED_METRIC_DOC = "The total number of responses sent in the given window.";
    static final String RECORD_ERROR_COUNT_WINDOWED_METRIC_NAME = "error-count-windowed";
    private static final String RECORD_ERROR_COUNT_WINDOWED_METRIC_DOC = "The total number of record sends that resulted in errors in the given window.";
    static final String RECORD_ERROR_RATE_METRIC_NAME = "record-error-rate";
    private static final String RECORD_ERROR_RATE_METRIC_DOC = "The average per-second number of record sends that resulted in errors.";
    static final String RECORD_RATE_LIMITED_COUNT_WINDOWED_METRIC_NAME = "record-rate-limited-count-windowed";
    private static final String RECORD_RATE_LIMITED_COUNT_WINDOWED_METRIC_DOC = "The total number of record sends that resulted in rate-limit errors in the given window.";
    static final String RECORD_RATE_LIMITED_RATE_METRIC_NAME = "record-rate-limited-rate";
    private static final String RECORD_RATE_LIMITED_RATE_METRIC_DOC = "The average per-second number of record sends that resulted in rate-limit errors.";
    static final String REQUEST_LATENCY_AVG_METRIC_NAME = "request-latency-avg";
    private static final String REQUEST_LATENCY_AVG_METRIC_DOC = "The average request latency";
    static final String REQUEST_LATENCY_MAX_METRIC_NAME = "request-latency-max";
    private static final String REQUEST_LATENCY_MAX_METRIC_DOC = "The max request latency";
    static final String REQUEST_LATENCY_PCT_METRIC_PREFIX = "request-latency-";
    private static final String REQUEST_LATENCY_PCT_METRIC_DOC = "Request latency percentiles.";
    private final Metrics metrics;
    private final String jmxPrefix;
    private final String requestSensorName;
    private final String requestSizeSensorName;
    private final String responseSensorName;
    private final String recordErrorSensorName;
    private final String recordRateLimitedSensorName;
    private final String requestLatencySensorName;

    ProducerMetrics(KafkaRestConfig config, Time time, Map<String, String> metricsTags) {
        this(config, metricsTags);
    }

    ProducerMetrics(KafkaRestConfig config, Map<String, String> metricsTags) {
        TreeMap<String, String> sortedMetricsTags = new TreeMap<String, String>(metricsTags);
        String sensorTags = sortedMetricsTags.keySet().stream().map(key -> ":" + (String)metricsTags.get(key)).collect(Collectors.joining());
        this.metrics = Objects.requireNonNull(config.getMetrics());
        this.jmxPrefix = config.getString("metrics.jmx.prefix");
        String sensorNamePrefix = this.jmxPrefix + ":produce-api-metrics:";
        this.recordErrorSensorName = sensorNamePrefix + RECORD_ERROR_SENSOR_NAME + sensorTags;
        this.recordRateLimitedSensorName = sensorNamePrefix + RECORD_RATE_LIMITED_SENSOR_NAME + sensorTags;
        this.requestSensorName = sensorNamePrefix + REQUEST_SENSOR_NAME + sensorTags;
        this.requestLatencySensorName = sensorNamePrefix + REQUEST_LATENCY_SENSOR_NAME + sensorTags;
        this.requestSizeSensorName = sensorNamePrefix + REQUEST_SIZE_SENSOR_NAME + sensorTags;
        this.responseSensorName = sensorNamePrefix + RESPONSE_SENSOR_NAME + sensorTags;
        this.setupSensors(sortedMetricsTags, sensorTags);
    }

    private void setupSensors(Map<String, String> metricsTags, String sensorTags) {
        this.setupRequestSensor(metricsTags, sensorTags);
        this.setupRequestSizeSensor(metricsTags, sensorTags);
        this.setupResponseSensor(metricsTags, sensorTags);
        this.setupRecordErrorSensor(metricsTags, sensorTags);
        this.setupRecordRateLimitedSensor(metricsTags, sensorTags);
        this.setupRequestLatencySensor(metricsTags, sensorTags);
    }

    private void setupRequestSensor(Map<String, String> metricsTags, String sensorTags) {
        Sensor requestSensor = this.createSensor(REQUEST_SENSOR_NAME, sensorTags);
        this.addRate(requestSensor, REQUEST_RATE_METRIC_NAME, REQUEST_RATE_METRIC_DOC, metricsTags);
        this.addWindowedCount(requestSensor, REQUEST_COUNT_WINDOWED_METRIC_NAME, REQUEST_COUNT_WINDOWED_METRIC_DOC, metricsTags);
    }

    private void setupRequestSizeSensor(Map<String, String> metricsTags, String sensorTags) {
        Sensor requestSizeSensor = this.createSensor(REQUEST_SIZE_SENSOR_NAME, sensorTags);
        requestSizeSensor.add((CompoundStat)this.createMeter(this.metrics, metricsTags, "request-byte", "request bytes"));
    }

    private Meter createMeter(Metrics metrics, Map<String, String> metricTags, String baseName, String descriptiveName) {
        MetricName rateMetricName = metrics.metricName(baseName + "-rate", GROUP_NAME, String.format("The number of %s per second", descriptiveName), metricTags);
        MetricName totalMetricName = metrics.metricName(baseName + "-total", GROUP_NAME, String.format("The total number of %s", descriptiveName), metricTags);
        return new Meter(rateMetricName, totalMetricName);
    }

    private void setupResponseSensor(Map<String, String> metricsTags, String sensorTags) {
        Sensor responseSensor = this.createSensor(RESPONSE_SENSOR_NAME, sensorTags);
        this.addRate(responseSensor, RESPONSE_RATE_METRIC_NAME, RESPONSE_RATE_METRIC_DOC, metricsTags);
        this.addWindowedCount(responseSensor, RESPONSE_COUNT_WINDOWED_METRIC_NAME, RESPONSE_COUNT_WINDOWED_METRIC_DOC, metricsTags);
    }

    private void setupRecordErrorSensor(Map<String, String> metricsTags, String sensorTags) {
        Sensor recordErrorSensor = this.createSensor(RECORD_ERROR_SENSOR_NAME, sensorTags);
        this.addRate(recordErrorSensor, RECORD_ERROR_RATE_METRIC_NAME, RECORD_ERROR_RATE_METRIC_DOC, metricsTags);
        this.addWindowedCount(recordErrorSensor, RECORD_ERROR_COUNT_WINDOWED_METRIC_NAME, RECORD_ERROR_COUNT_WINDOWED_METRIC_DOC, metricsTags);
    }

    private void setupRecordRateLimitedSensor(Map<String, String> metricsTags, String sensorTags) {
        Sensor recordRateLimitedSensor = this.createSensor(RECORD_RATE_LIMITED_SENSOR_NAME, sensorTags);
        this.addRate(recordRateLimitedSensor, RECORD_RATE_LIMITED_RATE_METRIC_NAME, RECORD_RATE_LIMITED_RATE_METRIC_DOC, metricsTags);
        this.addWindowedCount(recordRateLimitedSensor, RECORD_RATE_LIMITED_COUNT_WINDOWED_METRIC_NAME, RECORD_RATE_LIMITED_COUNT_WINDOWED_METRIC_DOC, metricsTags);
    }

    private void setupRequestLatencySensor(Map<String, String> metricsTags, String sensorTags) {
        Sensor requestLatencySensor = this.createSensor(REQUEST_LATENCY_SENSOR_NAME, sensorTags);
        this.addMax(requestLatencySensor, REQUEST_LATENCY_MAX_METRIC_NAME, REQUEST_LATENCY_MAX_METRIC_DOC, metricsTags);
        this.addAvg(requestLatencySensor, REQUEST_LATENCY_AVG_METRIC_NAME, REQUEST_LATENCY_AVG_METRIC_DOC, metricsTags);
        this.addPercentiles(requestLatencySensor, REQUEST_LATENCY_PCT_METRIC_PREFIX, (Map<String, Double>)ImmutableMap.of((Object)"p95", (Object)0.95, (Object)"p99", (Object)0.99, (Object)"p999", (Object)0.999), REQUEST_LATENCY_PCT_METRIC_DOC, metricsTags);
    }

    private Sensor createSensor(String name, String sensorTags) {
        String fullSensorName = String.join((CharSequence)":", this.jmxPrefix, GROUP_NAME, name);
        fullSensorName = fullSensorName.concat(sensorTags);
        return this.metrics.sensor(fullSensorName, null, EXPIRY_SECONDS, new Sensor[0]);
    }

    private void addAvg(Sensor sensor, String name, String doc, Map<String, String> metricsTags) {
        sensor.add(this.getMetricName(name, doc, metricsTags), (MeasurableStat)new Avg());
    }

    private void addRate(Sensor sensor, String name, String doc, Map<String, String> metricsTags) {
        sensor.add(this.getMetricName(name, doc, metricsTags), (MeasurableStat)new Rate());
    }

    private void addMax(Sensor sensor, String name, String doc, Map<String, String> metricsTags) {
        sensor.add(this.getMetricName(name, doc, metricsTags), (MeasurableStat)new Max());
    }

    private void addWindowedCount(Sensor sensor, String name, String doc, Map<String, String> metricsTags) {
        sensor.add(this.getMetricName(name, doc, metricsTags), (MeasurableStat)new WindowedCount());
    }

    private void addPercentiles(Sensor sensor, String prefix, Map<String, Double> percentiles, String doc, Map<String, String> metricsTags) {
        sensor.add((CompoundStat)new Percentiles(120000, 30000.0, Percentiles.BucketSizing.CONSTANT, (Percentile[])percentiles.entrySet().stream().map(entry -> new Percentile(this.getMetricName(prefix + (String)entry.getKey(), doc, metricsTags), ((Double)entry.getValue()).doubleValue())).toArray(Percentile[]::new)));
    }

    @VisibleForTesting
    protected MetricName getMetricName(String name, String doc, Map<String, String> metricsTags) {
        return this.metrics.metricInstance(new MetricNameTemplate(name, GROUP_NAME, doc, metricsTags.keySet()), metricsTags);
    }

    void recordResponse() {
        this.recordMetric(this.responseSensorName, 1.0);
    }

    void recordRequestLatency(long valueMs) {
        this.recordMetric(this.requestLatencySensorName, valueMs);
    }

    void recordError() {
        this.recordMetric(this.recordErrorSensorName, 1.0);
    }

    void recordRateLimited() {
        this.recordMetric(this.recordRateLimitedSensorName, 1.0);
    }

    void recordRequest() {
        this.recordMetric(this.requestSensorName, 1.0);
    }

    void recordRequestSize(double value) {
        this.recordMetric(this.requestSizeSensorName, value);
    }

    private void recordMetric(String sensorName, double value) {
        Sensor sensor = this.metrics.getSensor(sensorName);
        if (sensor != null) {
            sensor.record(value);
        }
    }
}

